package com.zurrtum.create.client.content.trains.schedule.destination;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.client.content.trains.schedule.IScheduleInput;
import com.zurrtum.create.client.foundation.gui.ModularGuiLineBuilder;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.trains.schedule.destination.TextScheduleInstruction;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_342;

public abstract class TextScheduleInstructionRender<T extends TextScheduleInstruction> implements IScheduleInput<T> {
    @Override
    public List<class_2561> getTitleAs(T input, String type) {
        return ImmutableList.of(
            CreateLang.translateDirect("schedule." + type + "." + input.getId().method_12832() + ".summary").method_27692(class_124.field_1065),
            CreateLang.translateDirect("generic.in_quotes", class_2561.method_43470(input.getLabelText()))
        );
    }

    public void initConfigurationWidgets(T input, ModularGuiLineBuilder builder) {
        builder.addTextInput(0, 121, (e, t) -> modifyEditBox(e), "Text");
    }

    protected void modifyEditBox(class_342 box) {
    }
}
