package com.zurrtum.create.client.flywheel.api.internal;

import com.zurrtum.create.client.flywheel.api.backend.Backend;
import com.zurrtum.create.client.flywheel.api.layout.LayoutBuilder;
import com.zurrtum.create.client.flywheel.api.registry.IdRegistry;
import com.zurrtum.create.client.flywheel.api.visualization.BlockEntityVisualizer;
import com.zurrtum.create.client.flywheel.api.visualization.EntityVisualizer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.impl.FlwApiLinkImpl;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1936;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import org.jetbrains.annotations.Nullable;

public interface FlwApiLink {
    FlwApiLink INSTANCE = new FlwApiLinkImpl();

    <T> IdRegistry<T> createIdRegistry();

    Backend getCurrentBackend();

    boolean isBackendOn();

    Backend getOffBackend();

    Backend getDefaultBackend();

    LayoutBuilder createLayoutBuilder();

    boolean supportsVisualization(@Nullable class_1936 var1);

    @Nullable VisualizationManager getVisualizationManager(@Nullable class_1936 var1);

    VisualizationManager getVisualizationManagerOrThrow(@Nullable class_1936 var1);

    <T extends class_2586> @Nullable BlockEntityVisualizer<? super T> getVisualizer(class_2591<T> var1);

    <T extends class_1297> @Nullable EntityVisualizer<? super T> getVisualizer(class_1299<T> var1);

    <T extends class_2586> void setVisualizer(class_2591<T> var1, @Nullable BlockEntityVisualizer<? super T> var2);

    <T extends class_1297> void setVisualizer(class_1299<T> var1, @Nullable EntityVisualizer<? super T> var2);
}
