package com.zurrtum.create.client.flywheel.api.visualization;

import com.zurrtum.create.client.flywheel.api.internal.FlwApiLink;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import org.jetbrains.annotations.Nullable;

/**
 * The registry for {@code Visualizer}s.
 */
public final class VisualizerRegistry {
    private VisualizerRegistry() {
    }

    /**
     * Gets the visualizer for the given block entity type, if one exists.
     *
     * @param type The block entity type to get the visualizer for.
     * @param <T>  The type of the block entity.
     * @return The visualizer for the given block entity type, or {@code null} if none exists.
     */
    @Nullable
    public static <T extends class_2586> BlockEntityVisualizer<? super T> getVisualizer(class_2591<T> type) {
        return FlwApiLink.INSTANCE.getVisualizer(type);
    }

    /**
     * Gets the visualizer for the given entity type, if one exists.
     *
     * @param type The entity type to get the visualizer for.
     * @param <T>  The type of the entity.
     * @return The visualizer for the given entity type, or {@code null} if none exists.
     */
    @Nullable
    public static <T extends class_1297> EntityVisualizer<? super T> getVisualizer(class_1299<T> type) {
        return FlwApiLink.INSTANCE.getVisualizer(type);
    }

    /**
     * Sets the visualizer for the given block entity type.
     *
     * @param type       The block entity type to set the visualizer for.
     * @param visualizer The visualizer to set.
     * @param <T>        The type of the block entity.
     */
    public static <T extends class_2586> void setVisualizer(class_2591<T> type, @Nullable BlockEntityVisualizer<? super T> visualizer) {
        FlwApiLink.INSTANCE.setVisualizer(type, visualizer);
    }

    /**
     * Sets the visualizer for the given entity type.
     *
     * @param type       The entity type to set the visualizer for.
     * @param visualizer The visualizer to set.
     * @param <T>        The type of the entity.
     */
    public static <T extends class_1297> void setVisualizer(class_1299<T> type, @Nullable EntityVisualizer<? super T> visualizer) {
        FlwApiLink.INSTANCE.setVisualizer(type, visualizer);
    }
}
