package com.zurrtum.create.client.flywheel.lib.transform;

import net.minecraft.class_2382;
import net.minecraft.class_243;
import org.joml.Vector3fc;
import org.joml.Vector3ic;

public interface Translate<Self extends Translate<Self>> {
    float CENTER = 0.5f;

    Self translate(float x, float y, float z);

    default Self translate(double x, double y, double z) {
        return translate((float) x, (float) y, (float) z);
    }

    default Self translate(float v) {
        return translate(v, v, v);
    }

    default Self translateX(float x) {
        return translate(x, 0, 0);
    }

    default Self translateY(float y) {
        return translate(0, y, 0);
    }

    default Self translateZ(float z) {
        return translate(0, 0, z);
    }

    default Self translate(class_2382 vec) {
        return translate(vec.method_10263(), vec.method_10264(), vec.method_10260());
    }

    default Self translate(Vector3ic vec) {
        return translate(vec.x(), vec.y(), vec.z());
    }

    default Self translate(Vector3fc vec) {
        return translate(vec.x(), vec.y(), vec.z());
    }

    default Self translate(class_243 vec) {
        return translate(vec.field_1352, vec.field_1351, vec.field_1350);
    }

    default Self translateBack(float x, float y, float z) {
        return translate(-x, -y, -z);
    }

    default Self translateBack(double x, double y, double z) {
        return translate(-x, -y, -z);
    }

    default Self translateBack(float v) {
        return translate(-v);
    }

    default Self translateBack(class_2382 vec) {
        return translateBack(vec.method_10263(), vec.method_10264(), vec.method_10260());
    }

    default Self translateBack(Vector3ic vec) {
        return translateBack(vec.x(), vec.y(), vec.z());
    }

    default Self translateBack(Vector3fc vec) {
        return translateBack(vec.x(), vec.y(), vec.z());
    }

    default Self translateBack(class_243 vec) {
        return translateBack(vec.field_1352, vec.field_1351, vec.field_1350);
    }

    default Self center() {
        return translate(CENTER);
    }

    default Self uncenter() {
        return translate(-CENTER);
    }

    /**
     * Translates this object randomly by a very small amount.
     *
     * @param seed The seed to use to generate the random offsets.
     * @return {@code this}
     */
    default Self nudge(int seed) {
        long randomBits = (long) seed * 31L * 493286711L;
        randomBits = randomBits * randomBits * 4392167121L + randomBits * 98761L;
        float xNudge = (((float) (randomBits >> 16 & 7L) + 0.5F) / 8.0F - 0.5F) * 0.004F;
        float yNudge = (((float) (randomBits >> 20 & 7L) + 0.5F) / 8.0F - 0.5F) * 0.004F;
        float zNudge = (((float) (randomBits >> 24 & 7L) + 0.5F) / 8.0F - 0.5F) * 0.004F;
        return translate(xNudge, yNudge, zNudge);
    }
}
