package com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip;

import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.kinetics.base.IRotate.StressImpact;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_3532;

import static net.minecraft.class_124.*;

public class GeneratingKineticTooltipBehaviour<T extends KineticBlockEntity> extends KineticTooltipBehaviour<T> {

    public GeneratingKineticTooltipBehaviour(T be) {
        super(be);
    }

    @Override
    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        if (!StressImpact.isEnabled())
            return false;
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);

        float stressBase = blockEntity.calculateAddedStressCapacity();
        if (class_3532.method_15347(stressBase, 0))
            return added;

        CreateLang.translate("gui.goggles.generator_stats").forGoggles(tooltip);
        CreateLang.translate("tooltip.capacityProvided").style(field_1080).forGoggles(tooltip);

        float speed = blockEntity.getTheoreticalSpeed();
        if (speed != blockEntity.getGeneratedSpeed() && speed != 0)
            stressBase *= blockEntity.getGeneratedSpeed() / speed;

        float stressTotal = Math.abs(stressBase * speed);

        CreateLang.number(stressTotal).translate("generic.unit.stress").style(field_1075).space()
            .add(CreateLang.translate("gui.goggles.at_current_speed").style(field_1063)).forGoggles(tooltip, 1);

        return true;
    }
}
