package com.zurrtum.create.client.foundation.ponder;

import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.content.kinetics.belt.BeltBlock;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.foundation.blockEntity.IMultiBlockEntityContainer;
import net.minecraft.class_2338;
import net.minecraft.class_2586;

public class PonderWorldBlockEntityFix {

    public static void fixControllerBlockEntities(PonderLevel world) {
        for (class_2586 blockEntity : world.getBlockEntities()) {

            if (blockEntity instanceof BeltBlockEntity beltBlockEntity) {
                if (!beltBlockEntity.isController())
                    continue;
                class_2338 controllerPos = blockEntity.method_11016();
                for (class_2338 blockPos : BeltBlock.getBeltChain(world, controllerPos)) {
                    class_2586 blockEntity2 = world.method_8321(blockPos);
                    if (!(blockEntity2 instanceof BeltBlockEntity belt2))
                        continue;
                    belt2.setController(controllerPos);
                }
            }

            if (blockEntity instanceof IMultiBlockEntityContainer multiBlockEntity) {
                class_2338 lastKnown = multiBlockEntity.getLastKnownPos();
                class_2338 current = blockEntity.method_11016();
                if (lastKnown == null || current == null)
                    continue;
                if (multiBlockEntity.isController())
                    continue;
                if (!lastKnown.equals(current)) {
                    class_2338 newControllerPos = multiBlockEntity.getController().method_10081(current.method_10059(lastKnown));
                    multiBlockEntity.setController(newControllerPos);
                }
            }

        }
    }

}