package com.zurrtum.create.client.foundation.utility;

import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2338.class_2339;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3959.class_242;
import net.minecraft.class_3959.class_3960;
import net.minecraft.class_3965;

public class RaycastHelper {

    public static class_3965 rayTraceRange(class_1937 level, class_1657 player, double range) {
        class_243 origin = player.method_33571();
        class_243 target = getTraceTarget(player, range, origin);
        class_3959 context = new class_3959(origin, target, class_3960.field_17558, class_242.field_1348, player);
        return level.method_17742(context);
    }

    public static PredicateTraceResult rayTraceUntil(class_1657 player, double range, Predicate<class_2338> predicate) {
        class_243 origin = player.method_33571();
        class_243 target = getTraceTarget(player, range, origin);
        return rayTraceUntil(origin, target, predicate);
    }

    public static class_243 getTraceTarget(class_1657 player, double range, class_243 origin) {
        float f = player.method_36455();
        float f1 = player.method_36454();
        float n1 = -f1 * class_3532.field_29847 - (float) Math.PI;
        float n2 = -f * class_3532.field_29847;
        float f2 = class_3532.method_15362(n1);
        float f3 = class_3532.method_15374(n1);
        float f4 = -class_3532.method_15362(n2);
        float f5 = class_3532.method_15374(n2);
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        return origin.method_1031((double) f6 * range, (double) f5 * range, (double) f7 * range);
    }

    public static PredicateTraceResult rayTraceUntil(class_243 start, class_243 end, Predicate<class_2338> predicate) {
        if (Double.isNaN(start.field_1352) || Double.isNaN(start.field_1351) || Double.isNaN(start.field_1350))
            return null;
        if (Double.isNaN(end.field_1352) || Double.isNaN(end.field_1351) || Double.isNaN(end.field_1350))
            return null;

        int dx = class_3532.method_15357(end.field_1352);
        int dy = class_3532.method_15357(end.field_1351);
        int dz = class_3532.method_15357(end.field_1350);
        int x = class_3532.method_15357(start.field_1352);
        int y = class_3532.method_15357(start.field_1351);
        int z = class_3532.method_15357(start.field_1350);

        class_2339 currentPos = new class_2338(x, y, z).method_25503();

        if (predicate.test(currentPos))
            return new PredicateTraceResult(currentPos.method_10062(), class_2350.method_10147(dx - x, dy - y, dz - z));

        int remainingDistance = 200;

        while (remainingDistance-- >= 0) {
            if (Double.isNaN(start.field_1352) || Double.isNaN(start.field_1351) || Double.isNaN(start.field_1350)) {
                return null;
            }

            if (x == dx && y == dy && z == dz) {
                return new PredicateTraceResult();
            }

            boolean flag2 = true;
            boolean flag = true;
            boolean flag1 = true;
            double d0 = 999.0D;
            double d1 = 999.0D;
            double d2 = 999.0D;

            if (dx > x) {
                d0 = (double) x + 1.0D;
            } else if (dx < x) {
                d0 = (double) x + 0.0D;
            } else {
                flag2 = false;
            }

            if (dy > y) {
                d1 = (double) y + 1.0D;
            } else if (dy < y) {
                d1 = (double) y + 0.0D;
            } else {
                flag = false;
            }

            if (dz > z) {
                d2 = (double) z + 1.0D;
            } else if (dz < z) {
                d2 = (double) z + 0.0D;
            } else {
                flag1 = false;
            }

            double d3 = 999.0D;
            double d4 = 999.0D;
            double d5 = 999.0D;
            double d6 = end.field_1352 - start.field_1352;
            double d7 = end.field_1351 - start.field_1351;
            double d8 = end.field_1350 - start.field_1350;

            if (flag2) {
                d3 = (d0 - start.field_1352) / d6;
            }

            if (flag) {
                d4 = (d1 - start.field_1351) / d7;
            }

            if (flag1) {
                d5 = (d2 - start.field_1350) / d8;
            }

            if (d3 == -0.0D) {
                d3 = -1.0E-4D;
            }

            if (d4 == -0.0D) {
                d4 = -1.0E-4D;
            }

            if (d5 == -0.0D) {
                d5 = -1.0E-4D;
            }

            class_2350 enumfacing;

            if (d3 < d4 && d3 < d5) {
                enumfacing = dx > x ? class_2350.field_11039 : class_2350.field_11034;
                start = new class_243(d0, start.field_1351 + d7 * d3, start.field_1350 + d8 * d3);
            } else if (d4 < d5) {
                enumfacing = dy > y ? class_2350.field_11033 : class_2350.field_11036;
                start = new class_243(start.field_1352 + d6 * d4, d1, start.field_1350 + d8 * d4);
            } else {
                enumfacing = dz > z ? class_2350.field_11043 : class_2350.field_11035;
                start = new class_243(start.field_1352 + d6 * d5, start.field_1351 + d7 * d5, d2);
            }

            x = class_3532.method_15357(start.field_1352) - (enumfacing == class_2350.field_11034 ? 1 : 0);
            y = class_3532.method_15357(start.field_1351) - (enumfacing == class_2350.field_11036 ? 1 : 0);
            z = class_3532.method_15357(start.field_1350) - (enumfacing == class_2350.field_11035 ? 1 : 0);
            currentPos.method_10103(x, y, z);

            if (predicate.test(currentPos))
                return new PredicateTraceResult(currentPos.method_10062(), enumfacing);
        }

        return new PredicateTraceResult();
    }

    public static class PredicateTraceResult {
        private class_2338 pos;
        private class_2350 facing;

        public PredicateTraceResult(class_2338 pos, class_2350 facing) {
            this.pos = pos;
            this.facing = facing;
        }

        public PredicateTraceResult() {
            // missed, no result
        }

        public class_2350 getFacing() {
            return facing;
        }

        public class_2338 getPos() {
            return pos;
        }

        public boolean missed() {
            return this.pos == null;
        }
    }
}
