package com.zurrtum.create.client.infrastructure.particle;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.class_1060;
import net.minecraft.class_11659;
import net.minecraft.class_11942;
import net.minecraft.class_11944;
import net.minecraft.class_11977;
import net.minecraft.class_12075;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_3940;
import net.minecraft.class_4588;
import net.minecraft.class_765;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import net.minecraft.client.render.*;
import org.joml.Vector3f;
import org.joml.Vector4f;

import java.util.Arrays;
import java.util.Map;

public class CubeParticleSubmittable implements class_11659.class_11947, class_11942 {
    public static final Vector3f[] CUBE = {
        // TOP
        new Vector3f(-1, -1, 1), new Vector3f(-1, -1, -1), new Vector3f(1, -1, -1), new Vector3f(1, -1, 1),

        // BOTTOM
        new Vector3f(1, 1, 1), new Vector3f(1, 1, -1), new Vector3f(-1, 1, -1), new Vector3f(-1, 1, 1),

        // FRONT
        new Vector3f(1, 1, -1), new Vector3f(1, -1, -1), new Vector3f(-1, -1, -1), new Vector3f(-1, 1, -1),

        // BACK
        new Vector3f(-1, 1, 1), new Vector3f(-1, -1, 1), new Vector3f(1, -1, 1), new Vector3f(1, 1, 1),

        // LEFT
        new Vector3f(1, 1, 1), new Vector3f(1, -1, 1), new Vector3f(1, -1, -1), new Vector3f(1, 1, -1),

        // RIGHT
        new Vector3f(-1, 1, -1), new Vector3f(-1, -1, -1), new Vector3f(-1, -1, 1), new Vector3f(-1, 1, 1)};

    private final Vertices vertices = new Vertices();
    private int particles;

    public void render(float x, float y, float z, float scale, int color) {
        vertices.vertex(x, y, z, scale, color);
        particles++;
    }

    @Override
    public void method_74316() {
        vertices.reset();
        particles = 0;
    }

    @Override
    public class_11944.class_12041 method_74755(class_11977.class_12051 cache) {
        int i = particles * 24;
        try (class_9799 bufferAllocator = class_9799.method_72201(i * class_290.field_1584.getVertexSize())) {
            class_287 bufferBuilder = new class_287(bufferAllocator, VertexFormat.class_5596.field_27382, class_290.field_1584);
            vertices.render((x, y, z, scale, color) -> drawFace(bufferBuilder, x, y, z, scale, color));
            class_11944.class_12042 layer = new class_11944.class_12042(0, vertices.nextVertexIndex() * 36);
            class_9801 builtBuffer = bufferBuilder.method_60794();
            if (builtBuffer != null) {
                cache.method_74835(builtBuffer.method_60818());
                RenderSystem.getSequentialBuffer(VertexFormat.class_5596.field_27382).method_68274(builtBuffer.method_60822().comp_751());
                GpuBufferSlice gpuBufferSlice = RenderSystem.getDynamicUniforms().method_71106(
                    RenderSystem.getModelViewMatrix(),
                    new Vector4f(1.0F, 1.0F, 1.0F, 1.0F),
                    new Vector3f(),
                    RenderSystem.getTextureMatrix(),
                    RenderSystem.getShaderLineWidth()
                );
                return new class_11944.class_12041(
                    builtBuffer.method_60822().comp_751(),
                    gpuBufferSlice,
                    Map.of(CubeParticleRenderer.RENDER_TYPE, layer)
                );
            }
        }
        return null;
    }

    private void drawFace(class_4588 buffer, float x, float y, float z, float scale, int color) {
        int light = class_765.field_32767;
        Vector3f vec = new Vector3f();
        for (int i = 0; i < 6; i++) {
            // 6 faces to a cube
            for (int j = 0; j < 4; j++) {
                CUBE[i * 4 + j].mul(scale, vec).add(x, y, z);
                buffer.method_22912(vec.x, vec.y, vec.z).method_22913((float) j / 2, j % 2).method_39415(color).method_60803(light);
            }
        }
    }

    @Override
    public void method_74324(
        class_11944.class_12041 buffers,
        class_11977.class_12051 cache,
        RenderPass renderPass,
        class_1060 manager,
        boolean translucent
    ) {
        if (translucent) {
            return;
        }
        RenderSystem.class_5590 shapeIndexBuffer = RenderSystem.getSequentialBuffer(VertexFormat.class_5596.field_27382);
        renderPass.setVertexBuffer(0, cache.method_74834());
        renderPass.setIndexBuffer(shapeIndexBuffer.method_68274(buffers.comp_4897()), shapeIndexBuffer.method_31924());
        renderPass.setUniform("DynamicTransforms", buffers.comp_4898());
        for (Map.Entry<class_3940.class_11941, class_11944.class_12042> entry : buffers.comp_4899().entrySet()) {
            renderPass.setPipeline(entry.getKey().comp_4896());
            renderPass.bindSampler("Sampler0", manager.method_4619(entry.getKey().comp_4895()).method_71659());
            renderPass.drawIndexed(0, 0, entry.getValue().comp_4901(), 1);
        }
    }

    @Override
    public void submit(class_11659 queue, class_12075 cameraRenderState) {
        if (particles > 0) {
            queue.method_74315(this);
        }
    }

    @FunctionalInterface
    public interface Consumer {
        void consume(float x, float y, float z, float scale, int color);
    }

    public static class Vertices {
        private int maxVertices = 1024;
        private float[] floatData = new float[12288];
        private int[] intData = new int[2048];
        private int nextVertexIndex;

        public void vertex(float x, float y, float z, float scale, int color) {
            if (nextVertexIndex >= maxVertices) {
                increaseCapacity();
            }
            int i = this.nextVertexIndex * 4;
            floatData[i++] = x;
            floatData[i++] = y;
            floatData[i++] = z;
            floatData[i] = scale;
            intData[nextVertexIndex * 2] = color;
            nextVertexIndex++;
        }

        public void render(Consumer consumer) {
            for (int i = 0; i < this.nextVertexIndex; i++) {
                int j = i * 4;
                consumer.consume(floatData[j++], floatData[j++], floatData[j++], floatData[j], intData[i]);
            }
        }

        public void reset() {
            nextVertexIndex = 0;
        }

        private void increaseCapacity() {
            maxVertices *= 2;
            floatData = Arrays.copyOf(floatData, maxVertices * 4);
            intData = Arrays.copyOf(intData, maxVertices);
        }

        public int nextVertexIndex() {
            return nextVertexIndex;
        }
    }
}
