package com.zurrtum.create.client.vanillin.config;

import com.zurrtum.create.client.flywheel.lib.visualization.SimpleBlockEntityVisualizer;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_827;

public class BlockEntityVisualizerBuilder<T extends class_2586> {
    private final Configurator configurator;
    private final class_2591<T> type;
    @Nullable
    private SimpleBlockEntityVisualizer.Factory<T> visualFactory;
    @Nullable
    private Predicate<T> skipVanillaRender;

    public BlockEntityVisualizerBuilder(Configurator configurator, class_2591<T> type) {
        this.configurator = configurator;
        this.type = type;
    }

    /**
     * Sets the visual factory for the block entity.
     *
     * @param visualFactory The visual factory.
     * @return {@code this}
     */
    public BlockEntityVisualizerBuilder<T> factory(SimpleBlockEntityVisualizer.Factory<T> visualFactory) {
        this.visualFactory = visualFactory;
        return this;
    }

    /**
     * Sets a predicate to determine whether to skip rendering with the vanilla {@link class_827}.
     *
     * @param skipVanillaRender The predicate.
     * @return {@code this}
     */
    public BlockEntityVisualizerBuilder<T> skipVanillaRender(Predicate<T> skipVanillaRender) {
        this.skipVanillaRender = skipVanillaRender;
        return this;
    }

    /**
     * Sets a predicate to never skip rendering with the vanilla {@link class_827}.
     *
     * @return {@code this}
     */
    public BlockEntityVisualizerBuilder<T> neverSkipVanillaRender() {
        this.skipVanillaRender = blockEntity -> false;
        return this;
    }

    /**
     * Constructs the block entity visualizer and sets it for the block entity type.
     *
     * @return The block entity visualizer.
     */
    public SimpleBlockEntityVisualizer<T> apply(boolean enabledByDefault) {
        Objects.requireNonNull(visualFactory, "Visual factory cannot be null!");
        if (skipVanillaRender == null) {
            skipVanillaRender = blockEntity -> true;
        }

        SimpleBlockEntityVisualizer<T> visualizer = new SimpleBlockEntityVisualizer<>(visualFactory, skipVanillaRender);
        configurator.register(type, visualizer, enabledByDefault);

        return visualizer;
    }
}
