package com.zurrtum.create.content.contraptions;

import com.zurrtum.create.*;
import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.actors.psi.PortableStorageInterfaceMovement;
import com.zurrtum.create.content.contraptions.actors.seat.SeatBlock;
import com.zurrtum.create.content.contraptions.actors.seat.SeatEntity;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.contraptions.elevator.ElevatorContraption;
import com.zurrtum.create.content.contraptions.glue.SuperGlueEntity;
import com.zurrtum.create.content.contraptions.mounted.MountedContraption;
import com.zurrtum.create.content.trains.entity.CarriageContraption;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.foundation.collision.Matrix3d;
import com.zurrtum.create.infrastructure.packet.s2c.*;
import io.netty.handler.codec.DecoderException;
import net.minecraft.class_10584;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1321;
import net.minecraft.class_1530;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1688;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3231;
import net.minecraft.class_3499.class_3501;
import net.minecraft.class_3532;
import net.minecraft.class_3619;
import net.minecraft.class_8942;
import net.minecraft.class_9129;
import net.minecraft.entity.*;
import net.minecraft.util.math.*;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.*;

public abstract class AbstractContraptionEntity extends class_1297 {

    private static final class_2940<Boolean> STALLED = class_2945.method_12791(AbstractContraptionEntity.class, class_2943.field_13323);
    private static final class_2940<Optional<UUID>> CONTROLLED_BY = class_2945.method_12791(
        AbstractContraptionEntity.class,
        AllSynchedDatas.OPTIONAL_UUID_HANDLER
    );

    public final Map<class_1297, MutableInt> collidingEntities;

    protected Contraption contraption;
    protected boolean initialized;
    protected boolean prevPosInvalid;
    private boolean skipActorStop;

    /*
     * staleTicks are a band-aid to prevent a frame or two of missing blocks between
     * contraption discard and off-thread block placement on disassembly
     *
     * FIXME this timeout should be longer but then also cancelled early based on a
     * chunk rebuild listener
     */
    public int staleTicks = 3;

    public AbstractContraptionEntity(class_1299<?> entityTypeIn, class_1937 worldIn) {
        super(entityTypeIn, worldIn);
        prevPosInvalid = true;
        collidingEntities = new IdentityHashMap<>();
    }

    protected void setContraption(Contraption contraption) {
        this.contraption = contraption;
        if (contraption == null)
            return;
        if (method_73183().method_8608())
            return;
        contraption.onEntityCreated(this);
    }

    @Override
    public void method_5784(class_1313 pType, class_243 pPos) {
        if (pType == class_1313.field_6309)
            return;
        if (pType == class_1313.field_6306)
            return;
        if (pType == class_1313.field_6310)
            return;
        super.method_5784(pType, pPos);
    }

    public boolean supportsTerrainCollision() {
        return contraption instanceof TranslatingContraption && !(contraption instanceof ElevatorContraption);
    }

    protected void contraptionInitialize() {
        contraption.onEntityInitialize(method_73183(), this);
        initialized = true;
    }

    public boolean collisionEnabled() {
        return true;
    }

    public void registerColliding(class_1297 collidingEntity) {
        collidingEntities.put(collidingEntity, new MutableInt());
    }

    public void addSittingPassenger(class_1297 passenger, int seatIndex) {
        for (class_1297 entity : method_5685()) {
            class_2338 seatOf = contraption.getSeatOf(entity.method_5667());
            if (seatOf != null && seatOf.equals(contraption.getSeats().get(seatIndex))) {
                if (entity instanceof class_1657)
                    return;
                if (!(passenger instanceof class_1657))
                    return;
                entity.method_5848();
            }
        }
        passenger.method_5873(this, true, true);
        if (passenger instanceof class_1321 ta)
            ta.method_6179(true);
        if (method_73183().method_8608())
            return;
        contraption.getSeatMapping().put(passenger.method_5667(), seatIndex);

        ((class_3215) method_73183().method_8398()).method_18754(
            this,
            new ContraptionSeatMappingPacket(method_5628(), contraption.getSeatMapping())
        );
    }

    @Override
    protected void method_5793(class_1297 passenger) {
        class_243 transformedVector = getPassengerPosition(passenger, 1);
        super.method_5793(passenger);
        if (passenger instanceof class_1321 ta)
            ta.method_6179(false);
        if (method_73183().method_8608())
            return;
        if (transformedVector != null && passenger instanceof class_1309 entity) {
            AllSynchedDatas.CONTRAPTION_DISMOUNT_LOCATION.set(entity, Optional.of(transformedVector));
        }
        contraption.getSeatMapping().remove(passenger.method_5667());

        ((class_3215) method_73183().method_8398()).method_18754(
            this,
            new ContraptionSeatMappingPacket(method_5628(), contraption.getSeatMapping(), passenger.method_5628())
        );
    }

    @Override
    public class_243 method_24829(class_1309 entityLiving) {
        class_243 position = super.method_24829(entityLiving);
        return AllSynchedDatas.CONTRAPTION_DISMOUNT_LOCATION.get(entityLiving).map(dismount -> {
            entityLiving.method_24830(false);
            AllSynchedDatas.CONTRAPTION_DISMOUNT_LOCATION.set(entityLiving, Optional.empty());
            if (entityLiving instanceof class_1657 player) {
                AllSynchedDatas.CONTRAPTION_MOUNT_LOCATION.get(player).ifPresent(mount -> {
                    AllSynchedDatas.CONTRAPTION_MOUNT_LOCATION.set(player, Optional.empty());
                    if (entityLiving instanceof class_3222 serverPlayer && !mount.method_24802(position, 5000))
                        AllAdvancements.LONG_TRAVEL.trigger(serverPlayer);
                });
            }
            return dismount;
        }).orElse(position);
    }

    @Override
    public void method_5865(class_1297 passenger, class_4738 callback) {
        if (!method_5626(passenger))
            return;
        class_243 transformedVector = getPassengerPosition(passenger, 1);
        if (transformedVector == null)
            return;

        float offset = -1 / 8f;
        if (passenger instanceof AbstractContraptionEntity)
            offset = 0.0f;
        callback.accept(
            passenger,
            transformedVector.field_1352,
            transformedVector.field_1351 + SeatEntity.getCustomEntitySeatOffset(passenger) + offset,
            transformedVector.field_1350
        );
    }

    public class_243 getPassengerPosition(class_1297 passenger, float partialTicks) {
        if (contraption == null)
            return null;

        UUID id = passenger.method_5667();
        if (passenger instanceof OrientedContraptionEntity) {
            class_2338 localPos = contraption.getBearingPosOf(id);
            if (localPos != null)
                return toGlobalVector(VecHelper.getCenterOf(localPos), partialTicks).method_1019(VecHelper.getCenterOf(class_2338.field_11176)).method_1023(.5f, 1, .5f);
        }

        class_238 bb = passenger.method_5829();
        double ySize = bb.method_17940();
        class_2338 seat = contraption.getSeatOf(id);
        if (seat == null)
            return null;

        class_243 transformedVector = toGlobalVector(
            class_243.method_24954(seat).method_1031(.5, -passenger.method_55668(this).field_1351 + ySize + .125 - SeatEntity.getCustomEntitySeatOffset(passenger), .5),
            partialTicks
        ).method_1019(VecHelper.getCenterOf(class_2338.field_11176)).method_1023(0.5, ySize, 0.5);
        return transformedVector;
    }

    @Override
    protected boolean method_5818(@NotNull class_1297 pPassenger) {
        if (pPassenger instanceof OrientedContraptionEntity)
            return true;
        return contraption.getSeatMapping().size() < contraption.getSeats().size();
    }

    public class_2561 getContraptionName() {
        return method_5477();
    }

    public Optional<UUID> getControllingPlayer() {
        return field_6011.method_12789(CONTROLLED_BY);
    }

    public void setControllingPlayer(@Nullable class_1309 player) {
        field_6011.method_12778(CONTROLLED_BY, player == null ? Optional.empty() : Optional.of(player.method_5667()));
    }

    public boolean startControlling(class_2338 controlsLocalPos, class_1657 player) {
        return false;
    }

    public boolean control(class_2338 controlsLocalPos, Collection<Integer> heldControls, class_1657 player) {
        return true;
    }

    public void stopControlling(class_2338 controlsLocalPos) {
        getControllingPlayer().map(method_73183()::method_18470).map(p -> (p instanceof class_3222) ? ((class_3222) p) : null)
            .ifPresent(p -> p.field_13987.method_14364(AllPackets.CONTROLS_ABORT));
        setControllingPlayer(null);
    }

    public boolean handlePlayerInteraction(class_1657 player, class_2338 localPos, class_2350 side, class_1268 interactionHand) {
        int indexOfSeat = contraption.getSeats().indexOf(localPos);
        if (indexOfSeat == -1 || player.method_5998(interactionHand).method_31574(AllItems.WRENCH)) {
            if (contraption.interactors.containsKey(localPos))
                return contraption.interactors.get(localPos).handlePlayerInteraction(player, interactionHand, localPos, this);
            return contraption.storage.handlePlayerStorageInteraction(contraption, player, localPos);
        }
        if (player.method_5765())
            return false;

        // Eject potential existing passenger
        class_1297 toDismount = null;
        for (Map.Entry<UUID, Integer> entry : contraption.getSeatMapping().entrySet()) {
            if (entry.getValue() != indexOfSeat)
                continue;
            for (class_1297 entity : method_5685()) {
                if (!entry.getKey().equals(entity.method_5667()))
                    continue;
                if (entity instanceof class_1657)
                    return false;
                toDismount = entity;
            }
        }

        if (toDismount != null && !method_73183().method_8608()) {
            class_243 transformedVector = getPassengerPosition(toDismount, 1);
            toDismount.method_5848();
            if (transformedVector != null)
                toDismount.method_5859(transformedVector.field_1352, transformedVector.field_1351, transformedVector.field_1350);
        }

        if (method_73183().method_8608())
            return true;
        addSittingPassenger(SeatBlock.getLeashed(method_73183(), player).or(player), indexOfSeat);
        return true;
    }

    public class_243 toGlobalVector(class_243 localVec, float partialTicks) {
        return toGlobalVector(localVec, partialTicks, false);
    }

    public class_243 toGlobalVector(class_243 localVec, float partialTicks, boolean prevAnchor) {
        class_243 anchor = prevAnchor ? getPrevAnchorVec() : getAnchorVec();
        class_243 rotationOffset = VecHelper.getCenterOf(class_2338.field_11176);
        localVec = localVec.method_1020(rotationOffset);
        localVec = applyRotation(localVec, partialTicks);
        localVec = localVec.method_1019(rotationOffset).method_1019(anchor);
        return localVec;
    }

    public class_243 toLocalVector(class_243 localVec, float partialTicks) {
        return toLocalVector(localVec, partialTicks, false);
    }

    public class_243 toLocalVector(class_243 globalVec, float partialTicks, boolean prevAnchor) {
        class_243 anchor = prevAnchor ? getPrevAnchorVec() : getAnchorVec();
        class_243 rotationOffset = VecHelper.getCenterOf(class_2338.field_11176);
        globalVec = globalVec.method_1020(anchor).method_1020(rotationOffset);
        globalVec = reverseRotation(globalVec, partialTicks);
        globalVec = globalVec.method_1019(rotationOffset);
        return globalVec;
    }

    @Override
    public void method_5773() {
        if (contraption == null) {
            method_31472();
            return;
        }

        collidingEntities.entrySet().removeIf(e -> e.getValue().incrementAndGet() > 3);

        field_6014 = method_23317();
        field_6036 = method_23318();
        field_5969 = method_23321();
        prevPosInvalid = false;

        if (!initialized)
            contraptionInitialize();

        contraption.tickStorage(this);
        tickContraption();
        super.method_5773();

        if (!(method_73183() instanceof class_3218 sl))
            return;

        for (class_1297 entity : method_5685()) {
            if (entity instanceof class_1657)
                continue;
            if (entity.method_31747())
                continue;
            if (sl.field_26934.method_31793(entity))
                continue;
            method_24201(entity);
        }
    }

    public void alignPassenger(class_1297 passenger) {
        class_243 motion = getContactPointMotion(passenger.method_33571());
        if (class_3532.method_20390(motion.method_1033(), 0))
            return;
        if (passenger instanceof class_1531)
            return;
        if (!(passenger instanceof class_1309 living))
            return;
        float prevAngle = living.method_36454();
        float angle = AngleHelper.deg(-class_3532.method_15349(motion.field_1352, motion.field_1350));
        angle = AngleHelper.angleLerp(0.4f, prevAngle, angle);
        if (method_73183().method_8608()) {
            class_10584 interpolator = living.method_66233();
            if (interpolator != null) {
                interpolator.field_55666.field_55670 = 0;
            }
            living.method_5683(0, 0);
            living.method_36456(angle);
            living.method_36457(0);
            living.method_63614();
            living.field_6283 = angle;
            living.field_6241 = angle;
        } else {
            living.method_36456(angle);
        }
    }

    public void setBlock(class_2338 localPos, class_3501 newInfo) {
        contraption.blocks.put(localPos, newInfo);
        ((class_3215) method_73183().method_8398()).method_18754(
            this,
            new ContraptionBlockChangedPacket(method_5628(), localPos, newInfo.comp_1342())
        );
    }

    protected abstract void tickContraption();

    public abstract class_243 applyRotation(class_243 localPos, float partialTicks);

    public abstract class_243 reverseRotation(class_243 localPos, float partialTicks);

    public void tickActors() {
        boolean stalledPreviously = contraption.stalled;

        if (!method_73183().method_8608())
            contraption.stalled = false;

        skipActorStop = true;
        for (MutablePair<class_3501, MovementContext> pair : contraption.getActors()) {
            MovementContext context = pair.right;
            class_3501 blockInfo = pair.left;
            MovementBehaviour actor = MovementBehaviour.REGISTRY.get(blockInfo.comp_1342());

            if (actor == null)
                continue;

            class_243 oldMotion = context.motion;
            class_243 actorPosition = toGlobalVector(VecHelper.getCenterOf(blockInfo.comp_1341()).method_1019(actor.getActiveAreaOffset(context)), 1);
            class_2338 gridPosition = class_2338.method_49638(actorPosition);
            boolean newPosVisited = !context.stall && shouldActorTrigger(context, blockInfo, actor, actorPosition, gridPosition);

            context.rotation = v -> applyRotation(v, 1);
            context.position = actorPosition;
            if (!isActorActive(context, actor) && !actor.mustTickWhileDisabled())
                continue;
            if (newPosVisited && !context.stall) {
                actor.visitNewPosition(context, gridPosition);
                if (!method_5805())
                    break;
                context.firstMovement = false;
            }
            if (!oldMotion.equals(context.motion)) {
                actor.onSpeedChanged(context, oldMotion, context.motion);
                if (!method_5805())
                    break;
            }
            actor.tick(context);
            if (!method_5805())
                break;
            contraption.stalled |= context.stall;
        }
        if (!method_5805()) {
            contraption.stop(method_73183());
            return;
        }
        skipActorStop = false;

        for (class_1297 entity : method_5685()) {
            if (!(entity instanceof OrientedContraptionEntity orientedCE))
                continue;
            if (!contraption.stabilizedSubContraptions.containsKey(entity.method_5667()))
                continue;
            if (orientedCE.contraption != null && orientedCE.contraption.stalled) {
                contraption.stalled = true;
                break;
            }
        }

        if (!method_73183().method_8608()) {
            if (!stalledPreviously && contraption.stalled)
                onContraptionStalled();
            field_6011.method_12778(STALLED, contraption.stalled);
            return;
        }

        contraption.stalled = isStalled();
    }

    public void refreshPSIs() {
        for (MutablePair<class_3501, MovementContext> pair : contraption.getActors()) {
            MovementContext context = pair.right;
            class_3501 blockInfo = pair.left;
            MovementBehaviour actor = MovementBehaviour.REGISTRY.get(blockInfo.comp_1342());
            if (actor instanceof PortableStorageInterfaceMovement && isActorActive(context, actor))
                if (context.position != null)
                    actor.visitNewPosition(context, class_2338.method_49638(context.position));
        }
    }

    protected boolean isActorActive(MovementContext context, MovementBehaviour actor) {
        return actor.isActive(context);
    }

    protected void onContraptionStalled() {
        ((class_3215) method_73183().method_8398()).method_18754(
            this,
            new ContraptionStallPacket(method_5628(), method_23317(), method_23318(), method_23321(), getStalledAngle())
        );
    }

    protected boolean shouldActorTrigger(
        MovementContext context,
        class_3501 blockInfo,
        MovementBehaviour actor,
        class_243 actorPosition,
        class_2338 gridPosition
    ) {
        class_243 previousPosition = context.position;
        if (previousPosition == null)
            return false;

        context.motion = actorPosition.method_1020(previousPosition);

        if (!method_73183().method_8608() && context.contraption.entity instanceof CarriageContraptionEntity cce && cce.getCarriage() != null) {
            Train train = cce.getCarriage().train;
            double actualSpeed = train.speedBeforeStall != null ? train.speedBeforeStall : train.speed;
            context.motion = context.motion.method_1029().method_1021(Math.abs(actualSpeed));
        }

        class_243 relativeMotion = context.motion;
        relativeMotion = reverseRotation(relativeMotion, 1);
        context.relativeMotion = relativeMotion;

        boolean ignoreMotionForFirstMovement = context.contraption instanceof CarriageContraption || actor instanceof PortableStorageInterfaceMovement;

        return !class_2338.method_49638(previousPosition)
            .equals(gridPosition) || (context.relativeMotion.method_1033() > 0 || ignoreMotionForFirstMovement) && context.firstMovement;
    }

    public void move(double x, double y, double z) {
        method_5814(method_23317() + x, method_23318() + y, method_23321() + z);
    }

    public class_243 getAnchorVec() {
        return method_73189();
    }

    public class_243 getPrevAnchorVec() {
        return getPrevPositionVec();
    }

    public float getYawOffset() {
        return 0;
    }

    @Override
    public void method_5814(double x, double y, double z) {
        super.method_5814(x, y, z);
        if (contraption == null)
            return;
        class_238 cbox = contraption.bounds;
        if (cbox == null)
            return;
        class_243 actualVec = getAnchorVec();
        method_5857(cbox.method_997(actualVec));
    }

    public static float yawFromVector(class_243 vec) {
        return (float) ((3 * Math.PI / 2 + Math.atan2(vec.field_1350, vec.field_1352)) / Math.PI * 180);
    }

    public static float pitchFromVector(class_243 vec) {
        return (float) ((Math.acos(vec.field_1351)) / Math.PI * 180);
    }

    public static class_1299.class_1300<?> build(class_1299.class_1300<?> builder) {
        @SuppressWarnings("unchecked") class_1299.class_1300<AbstractContraptionEntity> entityBuilder = (class_1299.class_1300<AbstractContraptionEntity>) builder;
        return entityBuilder.method_17687(1, 1);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(STALLED, false);
        builder.method_56912(CONTROLLED_BY, Optional.empty());
    }

    @Override
    public class_2596<class_2602> method_18002(class_3231 entityTrackerEntry) {
        try (class_8942.class_11340 logging = new class_8942.class_11340(method_71370(), Create.LOGGER)) {
            class_11362 view = class_11362.method_71459(logging, method_56673());
            writeAdditional(view, true);
            return new NbtSpawnPacket(this, entityTrackerEntry, view.method_71475());
        }
    }

    @Override
    protected final void method_5652(class_11372 view) {
        writeAdditional(view, false);
    }

    protected void writeAdditional(class_11372 view, boolean spawnPacket) {
        if (contraption != null)
            contraption.write(view.method_71461("Contraption"), spawnPacket);
        view.method_71472("Stalled", isStalled());
        view.method_71472("Initialized", initialized);
    }

    @Override
    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        class_2487 nbt = ((NbtSpawnPacket) packet).getNbt();
        if (nbt == null) {
            return;
        }
        try (class_8942.class_11340 logging = new class_8942.class_11340(method_71370(), Create.LOGGER)) {
            readAdditional(class_11352.method_71417(logging, method_56673(), nbt), true);
        }
    }

    @Override
    protected final void method_5749(class_11368 view) {
        readAdditional(view, false);
    }

    @Nullable
    private static class_2487 readAnySizeNbt(class_9129 buf) {
        class_2520 tag = buf.method_30616(class_2505.method_53898());
        if (tag != null && !(tag instanceof class_2487)) {
            throw new DecoderException("Not a compound tag: " + tag);
        } else {
            return (class_2487) tag;
        }
    }

    protected void readAdditional(class_11368 view, boolean spawnData) {
        initialized = view.method_71433("Initialized", false);
        contraption = Contraption.fromData(method_73183(), view.method_71434("Contraption"), spawnData);
        contraption.entity = this;
        field_6011.method_12778(STALLED, view.method_71433("Stalled", false));
    }

    public void disassemble() {
        if (!method_5805())
            return;
        if (contraption == null)
            return;

        StructureTransform transform = makeStructureTransform();

        contraption.stop(method_73183());
        if (method_73183().method_8398() instanceof class_3215 manager) {
            manager.method_18754(this, new ContraptionDisassemblyPacket(this.method_5628(), transform));
        }

        contraption.addBlocksToWorld(method_73183(), transform);
        contraption.addPassengersToWorld(method_73183(), transform, method_5685());

        for (class_1297 entity : method_5685()) {
            if (!(entity instanceof OrientedContraptionEntity))
                continue;
            UUID id = entity.method_5667();
            if (!contraption.stabilizedSubContraptions.containsKey(id))
                continue;
            class_2338 transformed = transform.apply(contraption.stabilizedSubContraptions.get(id).getConnectedPos());
            entity.method_5814(transformed.method_10263(), transformed.method_10264(), transformed.method_10260());
            ((AbstractContraptionEntity) entity).disassemble();
        }

        skipActorStop = true;
        method_31472();

        method_5772();
        moveCollidedEntitiesOnDisassembly(transform);
        AllSoundEvents.CONTRAPTION_DISASSEMBLE.playOnServer(method_73183(), method_24515());
    }

    public void moveCollidedEntitiesOnDisassembly(StructureTransform transform) {
        for (class_1297 entity : collidingEntities.keySet()) {
            class_243 localVec = toLocalVector(entity.method_73189(), 0);
            class_243 transformed = transform.apply(localVec);
            if (method_73183().method_8608())
                entity.method_5814(transformed.field_1352, transformed.field_1351 + 1 / 16f, transformed.field_1350);
            else
                entity.method_5859(transformed.field_1352, transformed.field_1351 + 1 / 16f, transformed.field_1350);
        }
    }

    @Override
    public void method_5650(class_5529 p_146834_) {
        if (!method_73183().method_8608() && !method_31481() && contraption != null && !skipActorStop)
            contraption.stop(method_73183());
        if (contraption != null)
            contraption.onEntityRemoved(this);
        super.method_5650(p_146834_);
    }

    protected abstract StructureTransform makeStructureTransform();

    @Override
    public void method_5768(class_3218 world) {
        method_5772();
        super.method_5768(world);
    }

    @Override
    protected void method_5825() {
        method_5772();
        super.method_5825();
    }

    @Override
    protected void method_5746() {
    }

    public Contraption getContraption() {
        return contraption;
    }

    public boolean isStalled() {
        return field_6011.method_12789(STALLED);
    }

    protected abstract float getStalledAngle();

    public abstract void handleStallInformation(double x, double y, double z, float angle);

    @Override
    public void method_5647(class_11372 view) {
        class_243 vec = method_73189();
        List<class_1297> passengers = method_5685();

        for (class_1297 entity : passengers) {
            // setPos has world accessing side-effects when removed == null
            entity.field_26995 = class_5529.field_27000;

            // Gather passengers into same chunk when saving
            class_243 prevVec = entity.method_73189();
            entity.method_23327(vec.field_1352, prevVec.field_1351, vec.field_1350);

            // Super requires all passengers to not be removed in order to write them to the
            // tag
            entity.field_26995 = null;
        }

        super.method_5647(view);
    }

    @Override
    // Make sure nothing can move contraptions out of the way
    public void method_18799(class_243 motionIn) {
    }

    @Override
    public class_3619 method_5657() {
        return class_3619.field_15975;
    }

    public void setContraptionMotion(class_243 vec) {
        super.method_18799(vec);
    }

    @Override
    public boolean method_5863() {
        return false;
    }

    @Override
    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        return false;
    }

    public class_243 getPrevPositionVec() {
        return prevPosInvalid ? method_73189() : new class_243(field_6014, field_6036, field_5969);
    }

    public abstract ContraptionRotationState getRotationState();

    public class_243 getContactPointMotion(class_243 globalContactPoint) {
        if (prevPosInvalid)
            return class_243.field_1353;

        class_243 contactPoint = toGlobalVector(toLocalVector(globalContactPoint, 0, true), 1, true);
        class_243 contraptionLocalMovement = contactPoint.method_1020(globalContactPoint);
        class_243 contraptionAnchorMovement = method_73189().method_1020(getPrevPositionVec());
        return contraptionLocalMovement.method_1019(contraptionAnchorMovement);
    }

    @Override
    public boolean method_30949(class_1297 e) {
        if (e instanceof class_1657 && e.method_7325())
            return false;
        if (e.field_5960)
            return false;
        if (e instanceof class_1530)
            return false;
        if (e instanceof class_1688)
            return !(contraption instanceof MountedContraption);
        if (e instanceof SuperGlueEntity)
            return false;
        if (e instanceof SeatEntity)
            return false;
        if (e instanceof class_1676)
            return false;
        if (e.method_5854() != null)
            return false;

        class_1297 riding = this.method_5854();
        while (riding != null) {
            if (riding == e)
                return false;
            riding = riding.method_5854();
        }

        return e.method_5657() == class_3619.field_15974;
    }

    @Override
    public boolean method_5817() {
        return false;
    }

    public static class ContraptionRotationState {
        public static final ContraptionRotationState NONE = new ContraptionRotationState();

        public float xRotation = 0;
        public float yRotation = 0;
        public float zRotation = 0;
        public float secondYRotation = 0;

        Matrix3d matrix;

        public Matrix3d asMatrix() {
            if (matrix != null)
                return matrix;

            matrix = new Matrix3d().asIdentity();
            if (xRotation != 0)
                matrix.multiply(new Matrix3d().asXRotation(AngleHelper.rad(-xRotation)));
            if (yRotation != 0)
                matrix.multiply(new Matrix3d().asYRotation(AngleHelper.rad(-yRotation)));
            if (zRotation != 0)
                matrix.multiply(new Matrix3d().asZRotation(AngleHelper.rad(-zRotation)));
            return matrix;
        }

        public boolean hasVerticalRotation() {
            return xRotation != 0 || zRotation != 0;
        }

        public float getYawOffset() {
            return secondYRotation;
        }

    }

    @Override
    protected boolean method_5876() {
        /*
         * Override this with an empty method to reduce enormous calculation time when
         * contraptions are in water WARNING: THIS HAS A BUNCH OF SIDE EFFECTS! - Fluids
         * will not try to change contraption movement direction - this.inWater and
         * this.isInWater() will return unreliable data - entities riding a contraption
         * will not cause water splashes (seats are their own entity so this should be
         * fine) - fall distance is not reset when the contraption is in water -
         * this.eyesInWater and this.canSwim() will always be false - swimming state
         * will never be updated
         */
        return false;
    }

    @Override
    public void method_56073(int ticks) {
        // Contraptions no longer catch fire
    }

    @Override
    public boolean method_5753() {
        return true;
    }

    // Contraptions shouldn't activate pressure plates and tripwires
    @Override
    public boolean method_5696() {
        return true;
    }

    public boolean isReadyForRender() {
        return initialized;
    }

    public boolean isAliveOrStale() {
        return method_5805() || method_73183().method_8608() ? staleTicks > 0 : false;
    }

    public boolean isPrevPosInvalid() {
        return prevPosInvalid;
    }
}
