package com.zurrtum.create.content.contraptions.chassis;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.api.contraption.transformable.TransformableBlock;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.foundation.block.IBE;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2465;
import net.minecraft.class_2470;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_3965;

public abstract class AbstractChassisBlock extends class_2465 implements IWrenchable, IBE<ChassisBlockEntity>, TransformableBlock {

    public AbstractChassisBlock(class_2251 properties) {
        super(properties);
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (!player.method_7294())
            return class_1269.field_52423;

        boolean isSlimeBall = stack.method_31573(AllItemTags.SLIME_BALLS) || stack.method_31574(AllItems.SUPER_GLUE);

        class_2746 affectedSide = getGlueableSide(state, hitResult.method_17780());
        if (affectedSide == null)
            return class_1269.field_52423;

        if (isSlimeBall && state.method_11654(affectedSide)) {
            for (class_2350 face : Iterate.directions) {
                class_2746 glueableSide = getGlueableSide(state, face);
                if (glueableSide != null && !state.method_11654(glueableSide) && glueAllowedOnSide(level, pos, state, face)) {
                    if (level.method_8608()) {
                        class_243 vec = hitResult.method_17784();
                        level.method_8406(class_2398.field_11246, vec.field_1352, vec.field_1351, vec.field_1350, 0, 0, 0);
                        return class_1269.field_5812;
                    }
                    AllSoundEvents.SLIME_ADDED.playOnServer(level, pos, .5f, 1);
                    state = state.method_11657(glueableSide, true);
                }
            }
            if (!level.method_8608())
                level.method_8501(pos, state);
            return class_1269.field_5812;
        }

        if ((!stack.method_7960() || !player.method_5715()) && !isSlimeBall)
            return class_1269.field_52423;
        if (state.method_11654(affectedSide) == isSlimeBall)
            return class_1269.field_52423;
        if (!glueAllowedOnSide(level, pos, state, hitResult.method_17780()))
            return class_1269.field_52423;
        if (level.method_8608()) {
            class_243 vec = hitResult.method_17784();
            level.method_8406(class_2398.field_11246, vec.field_1352, vec.field_1351, vec.field_1350, 0, 0, 0);
            return class_1269.field_5812;
        }

        AllSoundEvents.SLIME_ADDED.playOnServer(level, pos, .5f, 1);
        level.method_8501(pos, state.method_11657(affectedSide, isSlimeBall));
        return class_1269.field_5812;
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        if (rotation == class_2470.field_11467)
            return state;

        class_2680 rotated = super.method_9598(state, rotation);
        for (class_2350 face : Iterate.directions) {
            class_2746 glueableSide = getGlueableSide(rotated, face);
            if (glueableSide != null)
                rotated = rotated.method_11657(glueableSide, false);
        }

        for (class_2350 face : Iterate.directions) {
            class_2746 glueableSide = getGlueableSide(state, face);
            if (glueableSide == null || !state.method_11654(glueableSide))
                continue;
            class_2350 rotatedFacing = rotation.method_10503(face);
            class_2746 rotatedGlueableSide = getGlueableSide(rotated, rotatedFacing);
            if (rotatedGlueableSide != null)
                rotated = rotated.method_11657(rotatedGlueableSide, true);
        }

        return rotated;
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirrorIn) {
        if (mirrorIn == class_2415.field_11302)
            return state;

        class_2680 mirrored = state;
        for (class_2350 face : Iterate.directions) {
            class_2746 glueableSide = getGlueableSide(mirrored, face);
            if (glueableSide != null)
                mirrored = mirrored.method_11657(glueableSide, false);
        }

        for (class_2350 face : Iterate.directions) {
            class_2746 glueableSide = getGlueableSide(state, face);
            if (glueableSide == null || !state.method_11654(glueableSide))
                continue;
            class_2350 mirroredFacing = mirrorIn.method_10343(face);
            class_2746 mirroredGlueableSide = getGlueableSide(mirrored, mirroredFacing);
            if (mirroredGlueableSide != null)
                mirrored = mirrored.method_11657(mirroredGlueableSide, true);
        }

        return mirrored;
    }

    @Override
    public class_2680 transform(class_2680 state, StructureTransform transform) {
        if (transform.mirror != null) {
            state = method_9569(state, transform.mirror);
        }

        if (transform.rotationAxis == class_2350.class_2351.field_11052) {
            return method_9598(state, transform.rotation);
        }
        return transformInner(state, transform);
    }

    protected class_2680 transformInner(class_2680 state, StructureTransform transform) {
        if (transform.rotation == class_2470.field_11467)
            return state;

        class_2680 rotated = state.method_11657(field_11459, transform.rotateAxis(state.method_11654(field_11459)));
        AbstractChassisBlock block = (AbstractChassisBlock) state.method_26204();

        for (class_2350 face : Iterate.directions) {
            class_2746 glueableSide = block.getGlueableSide(rotated, face);
            if (glueableSide != null)
                rotated = rotated.method_11657(glueableSide, false);
        }

        for (class_2350 face : Iterate.directions) {
            class_2746 glueableSide = block.getGlueableSide(state, face);
            if (glueableSide == null || !state.method_11654(glueableSide))
                continue;
            class_2350 rotatedFacing = transform.rotateFacing(face);
            class_2746 rotatedGlueableSide = block.getGlueableSide(rotated, rotatedFacing);
            if (rotatedGlueableSide != null)
                rotated = rotated.method_11657(rotatedGlueableSide, true);
        }

        return rotated;
    }

    public abstract class_2746 getGlueableSide(class_2680 state, class_2350 face);

    protected boolean glueAllowedOnSide(class_1922 world, class_2338 pos, class_2680 state, class_2350 side) {
        return true;
    }

    @Override
    public Class<ChassisBlockEntity> getBlockEntityClass() {
        return ChassisBlockEntity.class;
    }

    @Override
    public class_2591<? extends ChassisBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.CHASSIS;
    }

}
