package com.zurrtum.create.content.decoration.bracket;

import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import org.jetbrains.annotations.Nullable;

import java.util.function.Predicate;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_6088;

public class BracketedBlockEntityBehaviour extends BlockEntityBehaviour<SmartBlockEntity> {

    public static final BehaviourType<BracketedBlockEntityBehaviour> TYPE = new BehaviourType<>();

    private class_2680 bracket;
    private boolean reRender;

    private Predicate<class_2680> pred;

    public BracketedBlockEntityBehaviour(SmartBlockEntity be) {
        this(be, state -> true);
    }

    public BracketedBlockEntityBehaviour(SmartBlockEntity be, Predicate<class_2680> pred) {
        super(be);
        this.pred = pred;
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void applyBracket(class_2680 state) {
        this.bracket = state;
        reRender = true;
        blockEntity.notifyUpdate();
        class_1937 world = getWorld();
        if (world.method_8608())
            return;
        blockEntity.method_11010().method_30101(world, getPos(), 3);
    }

    public void transformBracket(StructureTransform transform) {
        if (isBracketPresent()) {
            class_2680 transformedBracket = transform.apply(bracket);
            applyBracket(transformedBracket);
        }
    }

    @Nullable
    public class_2680 removeBracket(boolean inOnReplacedContext) {
        if (bracket == null) {
            return null;
        }

        class_2680 removed = this.bracket;
        class_1937 world = getWorld();
        if (!world.method_8608())
            world.method_20290(class_6088.field_31144, getPos(), class_2248.method_9507(bracket));
        this.bracket = null;
        reRender = true;
        if (inOnReplacedContext) {
            blockEntity.sendData();
            return removed;
        }
        blockEntity.notifyUpdate();
        if (world.method_8608())
            return removed;
        blockEntity.method_11010().method_30101(world, getPos(), 3);
        return removed;
    }

    public boolean isBracketPresent() {
        return bracket != null;
    }

    public boolean isBracketValid(class_2680 bracketState) {
        return bracketState.method_26204() instanceof BracketBlock;
    }

    @Nullable
    public class_2680 getBracket() {
        return bracket;
    }

    public boolean canHaveBracket() {
        return pred.test(blockEntity.method_11010());
    }

    @Override
    public ItemRequirement getRequiredItems() {
        if (!isBracketPresent()) {
            return ItemRequirement.NONE;
        }
        return ItemRequirement.of(bracket, null);
    }

    @Override
    public boolean isSafeNBT() {
        return true;
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        if (isBracketPresent() && isBracketValid(bracket)) {
            view.method_71468("Bracket", class_2680.field_24734, bracket);
        }
        if (clientPacket && reRender) {
            view.method_71472("Redraw", true);
            reRender = false;
        }
        super.write(view, clientPacket);
    }

    @Override
    public void read(class_11368 view, boolean clientPacket) {
        view.method_71426("Bracket", class_2680.field_24734).ifPresent(state -> {
            bracket = null;
            if (isBracketValid(state))
                bracket = state;
        });
        if (clientPacket && view.method_71433("Redraw", false))
            getWorld().method_8413(getPos(), blockEntity.method_11010(), blockEntity.method_11010(), 16);
        super.read(view, clientPacket);
    }

}
