package com.zurrtum.create.content.equipment.zapper.terrainzapper;

import com.zurrtum.create.infrastructure.component.TerrainTools;
import org.apache.commons.lang3.tuple.Pair;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class FlattenTool {

    // gaussian with sig=1
    static float[][] kernel = {

        {0.003765f, 0.015019f, 0.023792f, 0.015019f, 0.003765f}, {0.015019f, 0.059912f, 0.094907f, 0.059912f, 0.015019f}, {0.023792f, 0.094907f, 0.150342f, 0.094907f, 0.023792f}, {0.015019f, 0.059912f, 0.094907f, 0.059912f, 0.015019f}, {0.003765f, 0.015019f, 0.023792f, 0.015019f, 0.003765f},

    };

    private static int[][] applyKernel(int[][] values) {
        int[][] result = new int[values.length][values[0].length];
        for (int i = 0; i < values.length; i++) {
            for (int j = 0; j < values[i].length; j++) {
                int value = values[i][j];
                float newValue = 0;
                for (int iOffset = -2; iOffset <= 2; iOffset++) {
                    for (int jOffset = -2; jOffset <= 2; jOffset++) {
                        int iTarget = i + iOffset;
                        int jTarget = j + jOffset;
                        int ref = 0;
                        if (iTarget < 0 || iTarget >= values.length || jTarget < 0 || jTarget >= values[0].length)
                            ref = value;
                        else
                            ref = values[iTarget][jTarget];
                        if (ref == Integer.MIN_VALUE)
                            ref = value;
                        newValue += kernel[iOffset + 2][jOffset + 2] * ref;
                    }
                }
                result[i][j] = class_3532.method_15375(newValue + .5f);
            }
        }
        return result;
    }

    public static void apply(class_1937 world, List<class_2338> targetPositions, class_2350 facing) {
        List<class_2338> surfaces = new ArrayList<>();
        Map<Pair<Integer, Integer>, Integer> heightMap = new HashMap<>();
        int offset = facing.method_10171().method_10181();

        int minEntry = Integer.MAX_VALUE;
        int minCoord1 = Integer.MAX_VALUE;
        int minCoord2 = Integer.MAX_VALUE;
        int maxEntry = Integer.MIN_VALUE;
        int maxCoord1 = Integer.MIN_VALUE;
        int maxCoord2 = Integer.MIN_VALUE;

        for (class_2338 p : targetPositions) {
            Pair<Integer, Integer> coords = getCoords(p, facing);
            class_2680 belowSurface = world.method_8320(p);

            minCoord1 = Math.min(minCoord1, coords.getKey());
            minCoord2 = Math.min(minCoord2, coords.getValue());
            maxCoord1 = Math.max(maxCoord1, coords.getKey());
            maxCoord2 = Math.max(maxCoord2, coords.getValue());

            if (TerrainTools.isReplaceable(belowSurface)) {
                if (!heightMap.containsKey(coords))
                    heightMap.put(coords, Integer.MIN_VALUE);
                continue;
            }

            p = p.method_10093(facing);
            class_2680 surface = world.method_8320(p);

            if (!TerrainTools.isReplaceable(surface)) {
                if (!heightMap.containsKey(coords) || heightMap.get(coords).equals(Integer.MIN_VALUE))
                    heightMap.put(coords, Integer.MAX_VALUE);
                continue;
            }

            surfaces.add(p);
            int coordinate = facing.method_10166().method_10173(p.method_10263(), p.method_10264(), p.method_10260());
            if (!heightMap.containsKey(coords) || heightMap.get(coords).equals(Integer.MAX_VALUE) || heightMap.get(coords)
                .equals(Integer.MIN_VALUE) || heightMap.get(coords) * offset < coordinate * offset) {
                heightMap.put(coords, coordinate);
                maxEntry = Math.max(maxEntry, coordinate);
                minEntry = Math.min(minEntry, coordinate);
            }
        }

        if (surfaces.isEmpty())
            return;

        // fill heightmap
        int[][] heightMapArray = new int[maxCoord1 - minCoord1 + 1][maxCoord2 - minCoord2 + 1];
        for (int i = 0; i < heightMapArray.length; i++) {
            for (int j = 0; j < heightMapArray[i].length; j++) {
                Pair<Integer, Integer> pair = Pair.of(minCoord1 + i, minCoord2 + j);
                if (!heightMap.containsKey(pair)) {
                    heightMapArray[i][j] = Integer.MIN_VALUE;
                    continue;
                }
                Integer height = heightMap.get(pair);
                if (height.equals(Integer.MAX_VALUE)) {
                    heightMapArray[i][j] = offset == 1 ? maxEntry + 2 : minEntry - 2;
                    continue;
                }
                if (height.equals(Integer.MIN_VALUE)) {
                    heightMapArray[i][j] = offset == 1 ? minEntry - 2 : maxEntry + 2;
                    continue;
                }

                heightMapArray[i][j] = height;
            }
        }

        heightMapArray = applyKernel(heightMapArray);

        for (class_2338 p : surfaces) {
            Pair<Integer, Integer> coords = getCoords(p, facing);
            int surfaceCoord = facing.method_10166().method_10173(p.method_10263(), p.method_10264(), p.method_10260()) * offset;
            int targetCoord = heightMapArray[coords.getKey() - minCoord1][coords.getValue() - minCoord2] * offset;

            // Keep surface
            if (surfaceCoord == targetCoord)
                continue;

            // Lower surface
            class_2680 blockState = world.method_8320(p);
            int timeOut = 1000;
            while (surfaceCoord > targetCoord) {
                class_2338 below = p.method_10093(facing.method_10153());
                world.method_8501(below, blockState);
                world.method_8501(p, blockState.method_26227().method_15759());
                p = p.method_10093(facing.method_10153());
                surfaceCoord--;
                if (timeOut-- <= 0)
                    break;
            }

            // Raise surface
            while (surfaceCoord < targetCoord) {
                class_2338 above = p.method_10093(facing);
                if (!(blockState.method_26204() instanceof class_2404))
                    world.method_8501(above, blockState);
                world.method_8501(p, world.method_8320(p.method_10093(facing.method_10153())));
                p = p.method_10093(facing);
                surfaceCoord++;
                if (timeOut-- <= 0)
                    break;
            }

        }
    }

    private static Pair<Integer, Integer> getCoords(class_2338 pos, class_2350 facing) {
        switch (facing.method_10166()) {
            case field_11048:
                return Pair.of(pos.method_10260(), pos.method_10264());
            case field_11052:
                return Pair.of(pos.method_10263(), pos.method_10260());
            case field_11051:
                return Pair.of(pos.method_10263(), pos.method_10264());
        }
        return null;
    }

}
