package com.zurrtum.create.content.fluids.pipes;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.content.decoration.bracket.BracketedBlockEntityBehaviour;
import com.zurrtum.create.content.fluids.FluidPropagator;
import com.zurrtum.create.content.fluids.FluidTransportBehaviour;
import com.zurrtum.create.content.fluids.pipes.valve.FluidValveBlock;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2680;

public class StraightPipeBlockEntity extends SmartBlockEntity {

    public StraightPipeBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.GLASS_FLUID_PIPE, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(new StraightPipeFluidTransportBehaviour(this));
        behaviours.add(new BracketedBlockEntityBehaviour(this));
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return FluidPropagator.getSharedTriggers();
    }

    public static class StraightPipeFluidTransportBehaviour extends FluidTransportBehaviour {

        public StraightPipeFluidTransportBehaviour(SmartBlockEntity be) {
            super(be);
        }

        @Override
        public boolean canHaveFlowToward(class_2680 state, class_2350 direction) {
            return state.method_28498(AxisPipeBlock.field_11459) && state.method_11654(AxisPipeBlock.field_11459) == direction.method_10166();
        }

        @Override
        public AttachmentTypes getRenderedRimAttachment(class_1920 world, class_2338 pos, class_2680 state, class_2350 direction) {
            AttachmentTypes attachment = super.getRenderedRimAttachment(world, pos, state, direction);
            class_2680 otherState = world.method_8320(pos.method_10093(direction));

            class_2351 axis = IAxisPipe.getAxisOf(state);
            class_2351 otherAxis = IAxisPipe.getAxisOf(otherState);

            if (attachment == AttachmentTypes.RIM && state.method_26204() instanceof FluidValveBlock)
                return AttachmentTypes.NONE;
            if (attachment == AttachmentTypes.RIM && !(state.method_26204() instanceof GlassFluidPipeBlock) && otherState.method_26204() instanceof GlassFluidPipeBlock)
                return AttachmentTypes.PARTIAL_RIM;

            if (attachment == AttachmentTypes.RIM && FluidPipeBlock.isPipe(otherState))
                return AttachmentTypes.NONE;
            if (axis == otherAxis && axis != null)
                return AttachmentTypes.NONE;

            if (otherState.method_26204() instanceof FluidValveBlock && FluidValveBlock.getPipeAxis(otherState) == direction.method_10166())
                return AttachmentTypes.NONE;

            return attachment.withoutConnector();
        }

    }

}
