package com.zurrtum.create.content.fluids.pump;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.content.fluids.FluidPropagator;
import com.zurrtum.create.content.fluids.FluidTransportBehaviour;
import com.zurrtum.create.content.fluids.PipeConnection;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import net.minecraft.class_11368;
import net.minecraft.class_1920;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class PumpBlockEntity extends KineticBlockEntity {

    Couple<MutableBoolean> sidesToUpdate;
    boolean pressureUpdate;

    // Backcompat- flips any pump blockstate that loads with reversed=true
    boolean scheduleFlip;

    public PumpBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.MECHANICAL_PUMP, pos, state);
        sidesToUpdate = Couple.create(MutableBoolean::new);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        behaviours.add(new PumpFluidTransferBehaviour(this));
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        List<CreateTrigger> list = FluidPropagator.getSharedTriggers();
        list.add(AllAdvancements.PUMP);
        return list;
    }

    @Override
    public void tick() {
        super.tick();

        if (field_11863.method_8608() && !isVirtual())
            return;

        if (scheduleFlip) {
            field_11863.method_8501(field_11867, method_11010().method_11657(PumpBlock.FACING, method_11010().method_11654(PumpBlock.FACING).method_10153()));
            scheduleFlip = false;
        }

        sidesToUpdate.forEachWithContext((update, isFront) -> {
            if (update.isFalse())
                return;
            update.setFalse();
            distributePressureTo(isFront ? getFront() : getFront().method_10153());
        });
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);

        if (Math.abs(previousSpeed) == Math.abs(getSpeed()))
            return;
        if (speed != 0)
            award(AllAdvancements.PUMP);
        if (field_11863.method_8608() && !isVirtual())
            return;

        updatePressureChange();
    }

    public void updatePressureChange() {
        pressureUpdate = false;
        class_2338 frontPos = field_11867.method_10093(getFront());
        class_2338 backPos = field_11867.method_10093(getFront().method_10153());
        FluidPropagator.propagateChangedPipe(field_11863, frontPos, field_11863.method_8320(frontPos));
        FluidPropagator.propagateChangedPipe(field_11863, backPos, field_11863.method_8320(backPos));

        FluidTransportBehaviour behaviour = getBehaviour(FluidTransportBehaviour.TYPE);
        if (behaviour != null)
            behaviour.wipePressure();
        sidesToUpdate.forEach(MutableBoolean::setTrue);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        if (view.method_71433("Reversed", false))
            scheduleFlip = true;
    }

    protected void distributePressureTo(class_2350 side) {
        if (getSpeed() == 0)
            return;

        BlockFace start = new BlockFace(field_11867, side);
        boolean pull = isPullingOnSide(isFront(side));
        Set<BlockFace> targets = new HashSet<>();
        Map<class_2338, Pair<Integer, Map<class_2350, Boolean>>> pipeGraph = new HashMap<>();

        if (!pull)
            FluidPropagator.resetAffectedFluidNetworks(field_11863, field_11867, side.method_10153());

        if (!hasReachedValidEndpoint(field_11863, start, pull)) {

            pipeGraph.computeIfAbsent(field_11867, $ -> Pair.of(0, new IdentityHashMap<>())).getSecond().put(side, pull);
            pipeGraph.computeIfAbsent(start.getConnectedPos(), $ -> Pair.of(1, new IdentityHashMap<>())).getSecond().put(side.method_10153(), !pull);

            List<Pair<Integer, class_2338>> frontier = new ArrayList<>();
            Set<class_2338> visited = new HashSet<>();
            int maxDistance = FluidPropagator.getPumpRange();
            frontier.add(Pair.of(1, start.getConnectedPos()));

            while (!frontier.isEmpty()) {
                Pair<Integer, class_2338> entry = frontier.remove(0);
                int distance = entry.getFirst();
                class_2338 currentPos = entry.getSecond();

                if (!field_11863.method_8477(currentPos))
                    continue;
                if (visited.contains(currentPos))
                    continue;
                visited.add(currentPos);
                class_2680 currentState = field_11863.method_8320(currentPos);
                FluidTransportBehaviour pipe = FluidPropagator.getPipe(field_11863, currentPos);
                if (pipe == null)
                    continue;

                for (class_2350 face : FluidPropagator.getPipeConnections(currentState, pipe)) {
                    BlockFace blockFace = new BlockFace(currentPos, face);
                    class_2338 connectedPos = blockFace.getConnectedPos();

                    if (!field_11863.method_8477(connectedPos))
                        continue;
                    if (blockFace.isEquivalent(start))
                        continue;
                    if (hasReachedValidEndpoint(field_11863, blockFace, pull)) {
                        pipeGraph.computeIfAbsent(currentPos, $ -> Pair.of(distance, new IdentityHashMap<>())).getSecond().put(face, pull);
                        targets.add(blockFace);
                        continue;
                    }

                    FluidTransportBehaviour pipeBehaviour = FluidPropagator.getPipe(field_11863, connectedPos);
                    if (pipeBehaviour == null)
                        continue;
                    if (pipeBehaviour instanceof PumpFluidTransferBehaviour)
                        continue;
                    if (visited.contains(connectedPos))
                        continue;
                    if (distance + 1 >= maxDistance) {
                        pipeGraph.computeIfAbsent(currentPos, $ -> Pair.of(distance, new IdentityHashMap<>())).getSecond().put(face, pull);
                        targets.add(blockFace);
                        continue;
                    }

                    pipeGraph.computeIfAbsent(currentPos, $ -> Pair.of(distance, new IdentityHashMap<>())).getSecond().put(face, pull);
                    pipeGraph.computeIfAbsent(connectedPos, $ -> Pair.of(distance + 1, new IdentityHashMap<>())).getSecond()
                        .put(face.method_10153(), !pull);
                    frontier.add(Pair.of(distance + 1, connectedPos));
                }
            }
        }

        // DFS
        Map<Integer, Set<BlockFace>> validFaces = new HashMap<>();
        searchForEndpointRecursively(pipeGraph, targets, validFaces, new BlockFace(start.getPos(), start.getOppositeFace()), pull);

        float pressure = Math.abs(getSpeed());
        for (Set<BlockFace> set : validFaces.values()) {
            int parallelBranches = Math.max(1, set.size() - 1);
            for (BlockFace face : set) {
                class_2338 pipePos = face.getPos();
                class_2350 pipeSide = face.getFace();

                if (pipePos.equals(field_11867))
                    continue;

                boolean inbound = pipeGraph.get(pipePos).getSecond().get(pipeSide);
                FluidTransportBehaviour pipeBehaviour = FluidPropagator.getPipe(field_11863, pipePos);
                if (pipeBehaviour == null)
                    continue;

                pipeBehaviour.addPressure(pipeSide, inbound, pressure / parallelBranches);
            }
        }

    }

    protected boolean searchForEndpointRecursively(
        Map<class_2338, Pair<Integer, Map<class_2350, Boolean>>> pipeGraph,
        Set<BlockFace> targets,
        Map<Integer, Set<BlockFace>> validFaces,
        BlockFace currentFace,
        boolean pull
    ) {
        class_2338 currentPos = currentFace.getPos();
        if (!pipeGraph.containsKey(currentPos))
            return false;
        Pair<Integer, Map<class_2350, Boolean>> pair = pipeGraph.get(currentPos);
        int distance = pair.getFirst();

        boolean atLeastOneBranchSuccessful = false;
        for (class_2350 nextFacing : Iterate.directions) {
            if (nextFacing == currentFace.getFace())
                continue;
            Map<class_2350, Boolean> map = pair.getSecond();
            if (!map.containsKey(nextFacing))
                continue;

            BlockFace localTarget = new BlockFace(currentPos, nextFacing);
            if (targets.contains(localTarget)) {
                validFaces.computeIfAbsent(distance, $ -> new HashSet<>()).add(localTarget);
                atLeastOneBranchSuccessful = true;
                continue;
            }

            if (map.get(nextFacing) != pull)
                continue;
            if (!searchForEndpointRecursively(
                pipeGraph,
                targets,
                validFaces,
                new BlockFace(currentPos.method_10093(nextFacing), nextFacing.method_10153()),
                pull
            ))
                continue;

            validFaces.computeIfAbsent(distance, $ -> new HashSet<>()).add(localTarget);
            atLeastOneBranchSuccessful = true;
        }

        if (atLeastOneBranchSuccessful)
            validFaces.computeIfAbsent(distance, $ -> new HashSet<>()).add(currentFace);

        return atLeastOneBranchSuccessful;
    }

    private boolean hasReachedValidEndpoint(class_1936 world, BlockFace blockFace, boolean pull) {
        class_2338 connectedPos = blockFace.getConnectedPos();
        class_2680 connectedState = world.method_8320(connectedPos);
        class_2586 blockEntity = world.method_8321(connectedPos);
        class_2350 face = blockFace.getFace();

        // facing a pump
        if (PumpBlock.isPump(connectedState) && connectedState.method_11654(PumpBlock.FACING)
            .method_10166() == face.method_10166() && blockEntity instanceof PumpBlockEntity pumpBE) {
            return pumpBE.isPullingOnSide(pumpBE.isFront(blockFace.getOppositeFace())) != pull;
        }

        // other pipe, no endpoint
        FluidTransportBehaviour pipe = FluidPropagator.getPipe(world, connectedPos);
        if (pipe != null && pipe.canHaveFlowToward(connectedState, blockFace.getOppositeFace()))
            return false;

        // fluid handler endpoint
        if (blockEntity != null) {
            boolean hasCapability = FluidHelper.hasFluidInventory(
                blockEntity.method_10997(),
                connectedPos,
                connectedState,
                blockEntity,
                face.method_10153()
            );
            if (hasCapability)
                return true;
        }

        // open endpoint
        return FluidPropagator.isOpenEnd(world, blockFace.getPos(), face);
    }

    public void updatePipesOnSide(class_2350 side) {
        if (!isSideAccessible(side))
            return;
        updatePipeNetwork(isFront(side));
        getBehaviour(FluidTransportBehaviour.TYPE).wipePressure();
    }

    protected boolean isFront(class_2350 side) {
        class_2680 blockState = method_11010();
        if (!(blockState.method_26204() instanceof PumpBlock))
            return false;
        class_2350 front = blockState.method_11654(PumpBlock.FACING);
        boolean isFront = side == front;
        return isFront;
    }

    @Nullable
    protected class_2350 getFront() {
        class_2680 blockState = method_11010();
        if (!(blockState.method_26204() instanceof PumpBlock))
            return null;
        return blockState.method_11654(PumpBlock.FACING);
    }

    protected void updatePipeNetwork(boolean front) {
        sidesToUpdate.get(front).setTrue();
    }

    public boolean isSideAccessible(class_2350 side) {
        class_2680 blockState = method_11010();
        if (!(blockState.method_26204() instanceof PumpBlock))
            return false;
        return blockState.method_11654(PumpBlock.FACING).method_10166() == side.method_10166();
    }

    public boolean isPullingOnSide(boolean front) {
        return !front;
    }

    class PumpFluidTransferBehaviour extends FluidTransportBehaviour {

        public PumpFluidTransferBehaviour(SmartBlockEntity be) {
            super(be);
        }

        @Override
        public void tick() {
            super.tick();
            for (Map.Entry<class_2350, PipeConnection> entry : interfaces.entrySet()) {
                boolean pull = isPullingOnSide(isFront(entry.getKey()));
                Couple<Float> pressure = entry.getValue().getPressure();
                pressure.set(pull, Math.abs(getSpeed()));
                pressure.set(!pull, 0f);
            }
        }

        @Override
        public boolean canHaveFlowToward(class_2680 state, class_2350 direction) {
            return isSideAccessible(direction);
        }

        @Override
        public AttachmentTypes getRenderedRimAttachment(class_1920 world, class_2338 pos, class_2680 state, class_2350 direction) {
            AttachmentTypes attachment = super.getRenderedRimAttachment(world, pos, state, direction);
            if (attachment == AttachmentTypes.RIM)
                return AttachmentTypes.NONE;
            return attachment;
        }

    }
}
