package com.zurrtum.create.content.kinetics.fan;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1937.class_7867;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3959.class_242;
import net.minecraft.class_3959.class_3960;

public class NozzleBlockEntity extends SmartBlockEntity {

    private final List<class_1297> pushingEntities = new ArrayList<>();
    private float range;
    private boolean pushing;
    private class_2338 fanPos;

    public NozzleBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.NOZZLE, pos, state);
        setLazyTickRate(5);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        if (!clientPacket)
            return;
        view.method_71464("Range", range);
        view.method_71472("Pushing", pushing);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        if (!clientPacket)
            return;
        range = view.method_71423("Range", 0);
        pushing = view.method_71433("Pushing", false);
    }

    @Override
    public void initialize() {
        fanPos = field_11867.method_10093(method_11010().method_11654(NozzleBlock.field_10927).method_10153());
        super.initialize();
    }

    @Override
    public void tick() {
        super.tick();

        float range = calcRange();
        if (this.range != range)
            setRange(range);

        class_243 center = VecHelper.getCenterOf(field_11867);
        if (field_11863.method_8608() && range != 0) {
            if (field_11863.field_9229.method_43048(class_3532.method_15340((AllConfigs.server().kinetics.fanPushDistance.get() - (int) range), 1, 10)) == 0) {
                class_243 start = VecHelper.offsetRandomly(center, field_11863.field_9229, pushing ? 1 : range / 2);
                class_243 motion = center.method_1020(start).method_1029()
                    .method_1021(class_3532.method_15363(range * (pushing ? .025f : 1f), 0, .5f) * (pushing ? -1 : 1));
                field_11863.method_8406(class_2398.field_11203, start.field_1352, start.field_1351, start.field_1350, motion.field_1352, motion.field_1351, motion.field_1350);
            }
        }

        for (Iterator<class_1297> iterator = pushingEntities.iterator(); iterator.hasNext(); ) {
            class_1297 entity = iterator.next();
            class_243 diff = entity.method_73189().method_1020(center);

            if (!(entity instanceof class_1657) && field_11863.method_8608())
                continue;

            double distance = diff.method_1033();
            if (distance > range || entity.method_5715() || AirCurrent.isPlayerCreativeFlying(entity)) {
                iterator.remove();
                continue;
            }

            if (!pushing && distance < 1.5f)
                continue;

            float factor = (entity instanceof class_1542) ? 1 / 128f : 1 / 32f;
            class_243 pushVec = diff.method_1029().method_1021((range - distance) * (pushing ? 1 : -1));
            entity.method_18799(entity.method_18798().method_1019(pushVec.method_1021(factor)));
            entity.field_6017 = 0;
            entity.field_6037 = true;
        }

    }

    public void setRange(float range) {
        this.range = range;
        if (range == 0)
            pushingEntities.clear();
        sendData();
    }

    private float calcRange() {
        class_2586 be = field_11863.method_8321(fanPos);
        if (!(be instanceof IAirCurrentSource source))
            return 0;

        if (source.getAirCurrent() == null)
            return 0;
        if (source.getSpeed() == 0)
            return 0;
        pushing = source.getAirFlowDirection() == source.getAirflowOriginSide();
        return source.getMaxDistance();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();

        if (range == 0)
            return;

        class_243 center = VecHelper.getCenterOf(field_11867);
        class_238 bb = new class_238(center, center).method_1014(range / 2f);

        for (class_1297 entity : field_11863.method_18467(class_1297.class, bb)) {
            class_243 diff = entity.method_73189().method_1020(center);

            double distance = diff.method_1033();
            if (distance > range || entity.method_5715() || AirCurrent.isPlayerCreativeFlying(entity))
                continue;

            boolean canSee = canSee(entity);
            if (!canSee) {
                pushingEntities.remove(entity);
                continue;
            }

            if (!pushingEntities.contains(entity))
                pushingEntities.add(entity);
        }

        for (Iterator<class_1297> iterator = pushingEntities.iterator(); iterator.hasNext(); ) {
            class_1297 entity = iterator.next();
            if (entity.method_5805())
                continue;
            iterator.remove();
        }

        if (!pushing && pushingEntities.size() > 256 && !field_11863.method_8608()) {
            field_11863.method_8437(null, center.field_1352, center.field_1351, center.field_1350, 2, class_7867.field_40888);
            for (Iterator<class_1297> iterator = pushingEntities.iterator(); iterator.hasNext(); ) {
                class_1297 entity = iterator.next();
                entity.method_31472();
                iterator.remove();
            }
        }

    }

    private boolean canSee(class_1297 entity) {
        class_3959 context = new class_3959(
            entity.method_73189(),
            VecHelper.getCenterOf(field_11867),
            class_3960.field_17558,
            class_242.field_1348,
            entity
        );
        return field_11867.equals(field_11863.method_17742(context).method_17777());
    }

}
