package com.zurrtum.create.content.kinetics.transmission;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.content.kinetics.RotationPropagator;
import com.zurrtum.create.content.kinetics.base.AbstractEncasedShaftBlock;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.foundation.block.IBE;
import net.minecraft.class_1750;
import net.minecraft.class_1937;
import net.minecraft.class_1953;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.minecraft.class_9904;
import org.jetbrains.annotations.Nullable;

public class GearshiftBlock extends AbstractEncasedShaftBlock implements IBE<SplitShaftBlockEntity> {

    public static final class_2746 POWERED = class_2741.field_12484;

    public GearshiftBlock(class_2251 properties) {
        super(properties);
        method_9590(method_9564().method_11657(POWERED, false));
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> builder) {
        builder.method_11667(POWERED);
        super.method_9515(builder);
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        return super.method_9605(context).method_11657(POWERED, context.method_8045().method_49803(context.method_8037()));
    }

    @Override
    public void method_9612(
        class_2680 state,
        class_1937 worldIn,
        class_2338 pos,
        class_2248 blockIn,
        @Nullable class_9904 wireOrientation,
        boolean isMoving
    ) {
        if (worldIn.method_8608())
            return;

        boolean previouslyPowered = state.method_11654(POWERED);
        if (previouslyPowered != worldIn.method_49803(pos)) {
            detachKinetics(worldIn, pos, true);
            worldIn.method_8652(pos, state.method_28493(POWERED), class_2248.field_31028);
        }
    }

    @Override
    public Class<SplitShaftBlockEntity> getBlockEntityClass() {
        return SplitShaftBlockEntity.class;
    }

    @Override
    public class_2591<? extends SplitShaftBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.GEARSHIFT;
    }

    public void detachKinetics(class_1937 worldIn, class_2338 pos, boolean reAttachNextTick) {
        class_2586 be = worldIn.method_8321(pos);
        if (be == null || !(be instanceof KineticBlockEntity))
            return;
        RotationPropagator.handleRemoved(worldIn, pos, (KineticBlockEntity) be);

        // Re-attach next tick
        if (reAttachNextTick)
            worldIn.method_64311(pos, this, 1, class_1953.field_9315);
    }

    @Override
    public void method_9588(class_2680 state, class_3218 worldIn, class_2338 pos, class_5819 random) {
        class_2586 be = worldIn.method_8321(pos);
        if (!(be instanceof KineticBlockEntity kte))
            return;
        RotationPropagator.handleAdded(worldIn, pos, kte);
    }
}
