package com.zurrtum.create.content.kinetics.waterwheel;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.zurrtum.create.foundation.block.IBE;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class LargeWaterWheelBlock extends RotatedPillarKineticBlock implements IBE<LargeWaterWheelBlockEntity> {

    public static final class_2746 EXTENSION = class_2746.method_11825("extension");

    public LargeWaterWheelBlock(class_2251 properties) {
        super(properties);
        method_9590(method_9564().method_11657(EXTENSION, false));
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder.method_11667(EXTENSION));
    }

    public class_2351 getAxisForPlacement(class_1750 context) {
        return super.method_9605(context).method_11654(AXIS);
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2680 stateForPlacement = super.method_9605(context);
        class_2338 pos = context.method_8037();
        class_2351 axis = stateForPlacement.method_11654(AXIS);

        for (int x = -1; x <= 1; x++) {
            for (int y = -1; y <= 1; y++) {
                for (int z = -1; z <= 1; z++) {
                    if (axis.method_10173(x, y, z) != 0)
                        continue;
                    class_2338 offset = new class_2338(x, y, z);
                    if (offset.equals(class_2338.field_11176))
                        continue;
                    class_2680 occupiedState = context.method_8045().method_8320(pos.method_10081(offset));
                    if (!occupiedState.method_45474())
                        return null;
                }
            }
        }

        if (context.method_8045().method_8320(pos.method_10093(class_2350.method_10169(axis, class_2352.field_11060))).method_27852(this))
            stateForPlacement = stateForPlacement.method_11657(EXTENSION, true);

        return stateForPlacement;
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        return onBlockEntityUseItemOn(level, pos, wwt -> wwt.applyMaterialIfValid(stack));
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        return class_1269.field_5811;
    }

    @Override
    public class_2680 method_9559(
        class_2680 pState,
        class_4538 world,
        class_10225 tickView,
        class_2338 pCurrentPos,
        class_2350 pDirection,
        class_2338 pNeighborPos,
        class_2680 pNeighborState,
        class_5819 random
    ) {
        if (pDirection != class_2350.method_10169(pState.method_11654(AXIS), class_2352.field_11060))
            return pState;
        return pState.method_11657(EXTENSION, pNeighborState.method_27852(this));
    }

    @Override
    public void method_9615(class_2680 state, class_1937 level, class_2338 pos, class_2680 oldState, boolean isMoving) {
        super.method_9615(state, level, pos, oldState, isMoving);
        if (!level.method_8397().method_8674(pos, this))
            level.method_64310(pos, this, 1);
    }

    @Override
    public void method_9588(class_2680 pState, class_3218 pLevel, class_2338 pPos, class_5819 pRandom) {
        class_2351 axis = pState.method_11654(AXIS);
        for (class_2350 side : Iterate.directions) {
            if (side.method_10166() == axis)
                continue;
            for (boolean secondary : Iterate.falseAndTrue) {
                class_2350 targetSide = secondary ? side.method_35833(axis) : side;
                class_2338 structurePos = (secondary ? pPos.method_10093(side) : pPos).method_10093(targetSide);
                class_2680 occupiedState = pLevel.method_8320(structurePos);
                class_2680 requiredStructure = AllBlocks.WATER_WHEEL_STRUCTURAL.method_9564()
                    .method_11657(WaterWheelStructuralBlock.field_10927, targetSide.method_10153());
                if (occupiedState == requiredStructure)
                    continue;
                if (!occupiedState.method_45474()) {
                    pLevel.method_22352(pPos, false);
                    return;
                }
                pLevel.method_8501(structurePos, requiredStructure);
            }
        }
        withBlockEntityDo(pLevel, pPos, WaterWheelBlockEntity::determineAndApplyFlowScore);
    }

    @Override
    public class_2591<? extends LargeWaterWheelBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.LARGE_WATER_WHEEL;
    }

    @Override
    public Class<LargeWaterWheelBlockEntity> getBlockEntityClass() {
        return LargeWaterWheelBlockEntity.class;
    }

    @Override
    public boolean hasShaftTowards(class_4538 world, class_2338 pos, class_2680 state, class_2350 face) {
        return face.method_10166() == getRotationAxis(state);
    }

    @Override
    public class_2351 getRotationAxis(class_2680 state) {
        return state.method_11654(AXIS);
    }

    @Override
    public float getParticleTargetRadius() {
        return 2.5f;
    }

    @Override
    public float getParticleInitialRadius() {
        return 2.25f;
    }
}
