package com.zurrtum.create.content.logistics.filter;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllMenuTypes;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;

public class PackageFilterMenu extends AbstractFilterMenu {

    public String address;

    public PackageFilterMenu(int id, class_1661 inv, class_1799 stack) {
        super(AllMenuTypes.PACKAGE_FILTER, id, inv, stack);
    }

    @Override
    protected int getPlayerInventoryXOffset() {
        return 40;
    }

    @Override
    protected int getPlayerInventoryYOffset() {
        return 101;
    }

    @Override
    protected void addFilterSlots() {
    }

    @Override
    protected ItemStackHandler createGhostInventory() {
        return new ItemStackHandler();
    }

    @Override
    public void clearContents() {
        address = "";
    }

    @Override
    protected void initAndReadInventory(class_1799 filterItem) {
        super.initAndReadInventory(filterItem);
        address = filterItem.method_58695(AllDataComponents.PACKAGE_ADDRESS, "");
    }

    @Override
    protected void saveData(class_1799 filterItem) {
        super.saveData(filterItem);
        if (address.isBlank())
            filterItem.method_57381(AllDataComponents.PACKAGE_ADDRESS);
        else
            filterItem.method_57379(AllDataComponents.PACKAGE_ADDRESS, address);
    }

    @Override
    public class_1799 method_7601(class_1657 playerIn, int index) {
        return class_1799.field_8037;
    }

}