package com.zurrtum.create.content.logistics.item.filter.attribute;

import com.mojang.serialization.Codec;
import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.api.registry.CreateRegistryKeys;
import com.zurrtum.create.catnip.codecs.CatnipCodecUtils;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public interface ItemAttribute {
    Codec<ItemAttribute> CODEC = CreateRegistries.ITEM_ATTRIBUTE_TYPE.method_39673().dispatch(ItemAttribute::getType, ItemAttributeType::codec);
    class_9139<class_9129, ItemAttribute> PACKET_CODEC = class_9135.method_56365(CreateRegistryKeys.ITEM_ATTRIBUTE_TYPE)
        .method_56440(ItemAttribute::getType, ItemAttributeType::packetCodec);

    static class_2487 saveStatic(ItemAttribute attribute, class_7225.class_7874 registries) {
        class_2487 nbt = new class_2487();
        nbt.method_10566("attribute", CatnipCodecUtils.encode(CODEC, registries, attribute).orElseThrow());
        return nbt;
    }

    @Nullable
    static ItemAttribute loadStatic(class_2487 nbt, class_7225.class_7874 registries) {
        return CatnipCodecUtils.decodeOrNull(CODEC, registries, nbt.method_10580("attribute"));
    }

    static List<ItemAttribute> getAllAttributes(class_1799 stack, class_1937 level) {
        List<ItemAttribute> attributes = new ArrayList<>();
        for (ItemAttributeType type : CreateRegistries.ITEM_ATTRIBUTE_TYPE) {
            attributes.addAll(type.getAllAttributes(stack, level));
        }
        return attributes;
    }

    boolean appliesTo(class_1799 stack, class_1937 world);

    ItemAttributeType getType();

    default class_5250 format(boolean inverted) {
        return class_2561.method_43469("create.item_attributes." + getTranslationKey() + (inverted ? ".inverted" : ""), getTranslationParameters());
    }

    String getTranslationKey();

    default Object[] getTranslationParameters() {
        return new String[0];
    }
}