package com.zurrtum.create.content.schematics.table;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllMenuTypes;
import com.zurrtum.create.foundation.gui.menu.MenuBase;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;

public class SchematicTableMenu extends MenuBase<SchematicTableBlockEntity> {

    private class_1735 inputSlot;
    private class_1735 outputSlot;

    public SchematicTableMenu(int id, class_1661 inv, SchematicTableBlockEntity be) {
        super(AllMenuTypes.SCHEMATIC_TABLE, id, inv, be);
    }

    public boolean canWrite() {
        return inputSlot.method_7681() && !outputSlot.method_7681();
    }

    @Override
    public class_1799 method_7601(class_1657 playerIn, int index) {
        class_1735 clickedSlot = method_7611(index);
        if (!clickedSlot.method_7681())
            return class_1799.field_8037;

        class_1799 stack = clickedSlot.method_7677();
        if (index < 2)
            method_7616(stack, 2, field_7761.size(), true);
        else
            method_7616(stack, 0, 1, false);

        return class_1799.field_8037;
    }

    @Override
    protected void initAndReadInventory(SchematicTableBlockEntity contentHolder) {
    }

    @Override
    protected void addSlots() {
        inputSlot = new class_1735(contentHolder.inventory, 0, 21, 59) {
            @Override
            public boolean method_7680(class_1799 stack) {
                return stack.method_31574(AllItems.EMPTY_SCHEMATIC) || stack.method_31574(AllItems.SCHEMATIC_AND_QUILL) || stack.method_31574(AllItems.SCHEMATIC);
            }
        };

        outputSlot = new class_1735(contentHolder.inventory, 1, 166, 59) {
            @Override
            public boolean method_7680(class_1799 stack) {
                return false;
            }
        };

        method_7621(inputSlot);
        method_7621(outputSlot);

        // player Slots
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.method_7621(new class_1735(player.method_31548(), col + row * 9 + 9, 38 + col * 18, 107 + row * 18));
            }
        }

        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.method_7621(new class_1735(player.method_31548(), hotbarSlot, 38 + hotbarSlot * 18, 165));
        }
    }

    @Override
    protected void saveData(SchematicTableBlockEntity contentHolder) {
    }

}