package com.zurrtum.create.content.trains.entity;

import com.google.common.base.Strings;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllEntityTypes;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.content.contraptions.OrientedContraptionEntity;
import com.zurrtum.create.content.contraptions.actors.trainControls.ControlsBlock;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.trains.entity.Carriage.DimensionalCarriageEntity;
import com.zurrtum.create.content.trains.entity.TravellingPoint.SteerDirection;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.content.trains.station.GlobalStation;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.entity.behaviour.EntityBehaviour;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.packet.s2c.ContraptionBlockChangedPacket;
import com.zurrtum.create.infrastructure.packet.s2c.TrainHUDControlUpdatePacket;
import com.zurrtum.create.infrastructure.packet.s2c.TrainPromptPacket;
import com.zurrtum.create.infrastructure.particle.CubeParticleData;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.lang.ref.WeakReference;
import java.util.*;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3499.class_3501;
import net.minecraft.class_3532;
import net.minecraft.class_4844;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5712;

public class CarriageContraptionEntity extends OrientedContraptionEntity {

    private static final class_2940<CarriageSyncData> CARRIAGE_DATA = class_2945.method_12791(
        CarriageContraptionEntity.class,
        AllSynchedDatas.CARRIAGE_DATA_HANDLER
    );
    private static final class_2940<Optional<UUID>> TRACK_GRAPH = class_2945.method_12791(
        CarriageContraptionEntity.class,
        AllSynchedDatas.OPTIONAL_UUID_HANDLER
    );
    private static final class_2940<Boolean> SCHEDULED = class_2945.method_12791(
        CarriageContraptionEntity.class,
        class_2943.field_13323
    );
    private final Map<BehaviourType<?>, EntityBehaviour<?>> behaviours = new Reference2ObjectArrayMap<>();

    public UUID trainId;
    public int carriageIndex;

    private Carriage carriage;
    public boolean validForRender;
    public boolean movingBackwards;

    public boolean leftTickingChunks;
    public boolean firstPositionUpdate;

    private boolean arrivalSoundPlaying;
    private boolean arrivalSoundReversed;
    private int arrivalSoundTicks;

    private class_243 serverPrevPos;

    public CarriageContraptionEntity(class_1299<? extends CarriageContraptionEntity> type, class_1937 world) {
        super(type, world);
        validForRender = false;
        firstPositionUpdate = true;
        arrivalSoundTicks = Integer.MIN_VALUE;
        derailParticleOffset = VecHelper.offsetRandomly(class_243.field_1353, world.field_9229, 1.5f).method_18805(1, .25f, 1);
        ArrayList<EntityBehaviour<?>> list = new ArrayList<>();
        AllClientHandle.INSTANCE.addBehaviours(this, list);
        list.forEach(b -> behaviours.put(b.getType(), b));
    }

    @SuppressWarnings("unchecked")
    public <T extends EntityBehaviour<?>> T getBehaviour(BehaviourType<T> type) {
        return (T) behaviours.get(type);
    }

    @Override
    public boolean method_66247() {
        return true;
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(CARRIAGE_DATA, new CarriageSyncData());
        builder.method_56912(TRACK_GRAPH, Optional.empty());
        builder.method_56912(SCHEDULED, false);
    }

    public void syncCarriage() {
        CarriageSyncData carriageData = getCarriageData();
        if (carriageData == null)
            return;
        if (carriage == null)
            return;
        carriageData.update(this, carriage);
    }

    @Override
    public void method_5674(class_2940<?> key) {
        super.method_5674(key);

        if (!method_73183().method_8608())
            return;

        bindCarriage();

        if (TRACK_GRAPH.equals(key))
            updateTrackGraph();

        if (CARRIAGE_DATA.equals(key)) {
            CarriageSyncData carriageData = getCarriageData();
            if (carriageData == null)
                return;
            if (carriage == null)
                return;
            carriageData.apply(this, carriage);
        }
    }

    public CarriageSyncData getCarriageData() {
        return field_6011.method_12789(CARRIAGE_DATA);
    }

    public boolean hasSchedule() {
        return field_6011.method_12789(SCHEDULED);
    }

    public void setServerSidePrevPosition() {
        serverPrevPos = method_73189();
    }

    @Override
    public class_243 getPrevPositionVec() {
        if (!method_73183().method_8608() && serverPrevPos != null)
            return serverPrevPos;
        return super.getPrevPositionVec();
    }

    public boolean isLocalCoordWithin(class_2338 localPos, int min, int max) {
        if (!(getContraption() instanceof CarriageContraption cc))
            return false;
        class_2350 facing = cc.getAssemblyDirection();
        class_2351 axis = facing.method_10170().method_10166();
        int coord = axis.method_10173(localPos.method_10260(), localPos.method_10264(), localPos.method_10263()) * -facing.method_10171().method_10181();
        return coord >= min && coord <= max;
    }

    public static CarriageContraptionEntity create(class_1937 world, CarriageContraption contraption) {
        CarriageContraptionEntity entity = new CarriageContraptionEntity(AllEntityTypes.CARRIAGE_CONTRAPTION, world);
        entity.setContraption(contraption);
        entity.setInitialOrientation(contraption.getAssemblyDirection().method_10170());
        entity.startAtInitialYaw();
        return entity;
    }

    @Override
    public void method_5773() {
        super.method_5773();

        if (contraption instanceof CarriageContraption cc)
            for (class_1297 entity : method_5685()) {
                if (entity instanceof class_1657)
                    continue;
                class_2338 seatOf = cc.getSeatOf(entity.method_5667());
                if (seatOf == null)
                    continue;
                if (cc.conductorSeats.get(seatOf) == null)
                    continue;
                alignPassenger(entity);
            }
        behaviours.values().forEach(EntityBehaviour::tick);
    }

    @Override
    public void setBlock(class_2338 localPos, class_3501 newInfo) {
        if (carriage == null)
            return;
        carriage.forEachPresentEntity(cce -> {
            cce.contraption.getBlocks().put(localPos, newInfo);
            ((class_3218) cce.method_73183()).method_14178()
                .method_18754(cce, new ContraptionBlockChangedPacket(cce.method_5628(), localPos, newInfo.comp_1342()));
        });
    }

    @Override
    protected void tickContraption() {
        if (nonDamageTicks > 0)
            nonDamageTicks--;
        if (!(contraption instanceof CarriageContraption cc))
            return;

        if (carriage == null) {
            if (method_73183().method_8608())
                bindCarriage();
            else
                method_31472();
            return;
        }

        if (!Create.RAILWAYS.sided(method_73183()).trains.containsKey(carriage.train.id)) {
            method_31472();
            return;
        }

        tickActors();
        boolean isStalled = isStalled();
        carriage.stalled = isStalled;

        CarriageSyncData carriageData = getCarriageData();

        if (!method_73183().method_8608()) {

            field_6011.method_12778(SCHEDULED, carriage.train.runtime.getSchedule() != null);

            boolean shouldCarriageSyncThisTick = carriage.train.shouldCarriageSyncThisTick(
                method_73183().method_8510(),
                method_5864().method_18388()
            );
            if (shouldCarriageSyncThisTick && carriageData.isDirty()) {
                field_6011.method_49743(CARRIAGE_DATA, carriageData, true);
                carriageData.setDirty(false);
            }

            Navigation navigation = carriage.train.navigation;
            if (navigation.announceArrival && Math.abs(navigation.distanceToDestination) < 60 && carriageIndex == (carriage.train.speed < 0 ? carriage.train.carriages.size() - 1 : 0)) {
                navigation.announceArrival = false;
                arrivalSoundPlaying = true;
                arrivalSoundReversed = carriage.train.speed < 0;
                arrivalSoundTicks = Integer.MIN_VALUE;
            }

            if (arrivalSoundPlaying)
                tickArrivalSound(cc);

            field_6011.method_12778(TRACK_GRAPH, Optional.ofNullable(carriage.train.graph).map(g -> g.id));

            method_73183().method_43275(this, class_5712.field_43315, method_73189());

            return;
        }

        DimensionalCarriageEntity dce = carriage.getDimensional(method_73183());
        if (field_6012 % 10 == 0)
            updateTrackGraph();

        if (!dce.pointsInitialised)
            return;

        carriageData.approach(this, carriage, 1f / method_5864().method_18388());

        if (!carriage.train.derailed)
            carriage.updateContraptionAnchors();

        field_6014 = method_23317();
        field_6036 = method_23318();
        field_5969 = method_23321();

        dce.alignEntity(this);

        double distanceTo = 0;
        if (!firstPositionUpdate) {
            class_243 diff = method_73189().method_1023(field_6014, field_6036, field_5969);
            class_243 relativeDiff = VecHelper.rotate(diff, yaw, class_2351.field_11052);
            double signum = Math.signum(-relativeDiff.field_1352);
            distanceTo = diff.method_1033() * signum;
            movingBackwards = signum < 0;
        }

        carriage.bogeys.getFirst().updateAngles(this, distanceTo);
        if (carriage.isOnTwoBogeys())
            carriage.bogeys.getSecond().updateAngles(this, distanceTo);

        if (carriage.train.derailed)
            spawnDerailParticles(carriage);
        if (dce.pivot != null)
            spawnPortalParticles(dce);

        firstPositionUpdate = false;
        validForRender = true;
    }

    private void bindCarriage() {
        if (carriage != null)
            return;
        Train train = Create.RAILWAYS.sided(method_73183()).trains.get(trainId);
        if (train == null || train.carriages.size() <= carriageIndex)
            return;
        carriage = train.carriages.get(carriageIndex);
        if (carriage != null) {
            DimensionalCarriageEntity dimensional = carriage.getDimensional(method_73183());
            dimensional.entity = new WeakReference<>(this);
            dimensional.pivot = null;
            carriage.updateContraptionAnchors();
            dimensional.updateRenderedCutoff();
        }
        updateTrackGraph();
    }

    private void tickArrivalSound(CarriageContraption cc) {
        List<Carriage> carriages = carriage.train.carriages;

        if (arrivalSoundTicks == Integer.MIN_VALUE) {
            int carriageCount = carriages.size();
            Integer tick = null;

            for (int index = 0; index < carriageCount; index++) {
                int i = arrivalSoundReversed ? carriageCount - 1 - index : index;
                Carriage carriage = carriages.get(i);
                CarriageContraptionEntity entity = carriage.getDimensional(method_73183()).entity.get();
                if (entity == null || !(entity.contraption instanceof CarriageContraption otherCC))
                    break;
                tick = arrivalSoundReversed ? otherCC.soundQueue.lastTick() : otherCC.soundQueue.firstTick();
                if (tick != null)
                    break;
            }

            if (tick == null) {
                arrivalSoundPlaying = false;
                return;
            }

            arrivalSoundTicks = tick;
        }

        if (field_6012 % 2 == 0)
            return;

        boolean keepTicking = false;
        for (Carriage c : carriages) {
            CarriageContraptionEntity entity = c.getDimensional(method_73183()).entity.get();
            if (entity == null || !(entity.contraption instanceof CarriageContraption otherCC))
                continue;
            keepTicking |= otherCC.soundQueue.tick(entity, arrivalSoundTicks, arrivalSoundReversed);
        }

        if (!keepTicking) {
            arrivalSoundPlaying = false;
            return;
        }

        arrivalSoundTicks += arrivalSoundReversed ? -1 : 1;
    }

    @Override
    public void tickActors() {
        super.tickActors();
    }

    @Override
    protected boolean isActorActive(MovementContext context, MovementBehaviour actor) {
        if (!(contraption instanceof CarriageContraption cc))
            return false;
        if (!super.isActorActive(context, actor))
            return false;
        return cc.notInPortal() || method_73183().method_8608();
    }

    @Override
    public void handleStallInformation(double x, double y, double z, float angle) {
    }

    class_243 derailParticleOffset;

    private void spawnDerailParticles(Carriage carriage) {
        if (field_5974.method_43057() < 1 / 20f) {
            class_243 v = method_73189().method_1019(derailParticleOffset);
            method_73183().method_8406(class_2398.field_17430, v.field_1352, v.field_1351, v.field_1350, 0, .04, 0);
        }
    }

    @Override
    protected void method_5627(class_1297 pPassenger) {
        super.method_5627(pPassenger);
        if (!(pPassenger instanceof class_1657 player))
            return;
        AllSynchedDatas.CONTRAPTION_MOUNT_LOCATION.set(player, Optional.ofNullable(player.method_73189()));
    }

    public Set<class_2338> particleSlice = new HashSet<>();
    public float particleAvgY = 0;

    private void spawnPortalParticles(DimensionalCarriageEntity dce) {
        class_243 pivot = dce.pivot.getLocation().method_1031(0, 1.5f, 0);
        if (particleSlice.isEmpty())
            return;

        boolean alongX = class_3532.method_20390(pivot.field_1352, Math.round(pivot.field_1352));
        int extraFlip = class_2350.method_10150(yaw).method_10171().method_10181();

        class_243 emitter = pivot.method_1031(0, particleAvgY, 0);
        double speed = method_73189().method_1022(getPrevPositionVec());
        int size = (int) (particleSlice.size() * class_3532.method_15350(4 - speed * 4, 0, 4));

        for (class_2338 pos : particleSlice) {
            if (size != 0 && field_5974.method_43048(size) != 0)
                continue;
            if (alongX)
                pos = new class_2338(0, pos.method_10264(), pos.method_10263());
            class_243 v = pivot.method_1031(pos.method_10263() * extraFlip, pos.method_10264(), pos.method_10260() * extraFlip);
            CubeParticleData data = new CubeParticleData(.25f, 0, .5f, .65f + (field_5974.method_43057() - .5f) * .25f, 4, false);
            class_243 m = v.method_1020(emitter).method_1029().method_1021(.325f);
            m = VecHelper.rotate(m, field_5974.method_43057() * 360, alongX ? class_2351.field_11048 : class_2351.field_11051);
            m = m.method_1019(VecHelper.offsetRandomly(class_243.field_1353, field_5974, 0.25f));
            method_73183().method_8406(data, v.field_1352, v.field_1351, v.field_1350, m.field_1352, m.field_1351, m.field_1350);
        }

    }

    @Override
    public void method_36209() {
        super.method_36209();
        field_6011.method_12778(CARRIAGE_DATA, new CarriageSyncData());
        if (carriage != null) {
            DimensionalCarriageEntity dce = carriage.getDimensional(method_73183());
            dce.pointsInitialised = false;
            carriage.leadingBogey().couplingAnchors = Couple.create(null, null);
            carriage.trailingBogey().couplingAnchors = Couple.create(null, null);
        }
        firstPositionUpdate = true;
        behaviours.values().forEach(EntityBehaviour::destroy);
    }

    @Override
    protected void writeAdditional(class_11372 view, boolean spawnPacket) {
        super.writeAdditional(view, spawnPacket);
        view.method_71468("TrainId", class_4844.field_25122, trainId);
        view.method_71465("CarriageIndex", carriageIndex);
    }

    @Override
    protected void readAdditional(class_11368 view, boolean spawnPacket) {
        super.readAdditional(view, spawnPacket);
        trainId = view.method_71426("TrainId", class_4844.field_25122).orElseThrow();
        carriageIndex = view.method_71424("CarriageIndex", 0);
        if (spawnPacket) {
            field_6038 = method_23317();
            field_5971 = method_23318();
            field_5989 = method_23321();
        }
    }

    @Override
    public class_2561 getContraptionName() {
        if (carriage != null)
            return carriage.train.name;
        return super.getContraptionName();
    }

    public Couple<Boolean> checkConductors() {
        Couple<Boolean> sides = Couple.create(false, false);
        if (!(contraption instanceof CarriageContraption cc))
            return sides;

        sides.setFirst(cc.blockConductors.getFirst());
        sides.setSecond(cc.blockConductors.getSecond());

        for (class_1297 entity : method_5685()) {
            if (entity instanceof class_1657)
                continue;
            class_2338 seatOf = cc.getSeatOf(entity.method_5667());
            if (seatOf == null)
                continue;
            Couple<Boolean> validSides = cc.conductorSeats.get(seatOf);
            if (validSides == null)
                continue;
            sides.setFirst(sides.getFirst() || validSides.getFirst());
            sides.setSecond(sides.getSecond() || validSides.getSecond());
        }

        return sides;
    }

    @Override
    public boolean startControlling(class_2338 controlsLocalPos, class_1657 player) {
        if (player == null || player.method_7325())
            return false;
        if (carriage == null)
            return false;
        if (carriage.train.derailed)
            return false;

        Train train = carriage.train;
        if (train.runtime.getSchedule() != null && !train.runtime.paused)
            train.status.manualControls();
        train.navigation.cancelNavigation();
        train.runtime.paused = true;
        train.navigation.waitingForSignal = null;
        return true;
    }

    @Override
    public class_2561 method_5476() {
        if (carriage == null)
            return class_2561.method_30163("create.train");
        return carriage.train.name;
    }

    double navDistanceTotal = 0;
    int hudPacketCooldown = 0;

    @Override
    public boolean control(class_2338 controlsLocalPos, Collection<Integer> heldControls, class_1657 player) {
        if (carriage == null)
            return false;
        if (carriage.train.derailed)
            return false;
        if (method_73183().method_8608())
            return true;
        if (player.method_7325())
            return false;
        if (!toGlobalVector(VecHelper.getCenterOf(controlsLocalPos), 1).method_24802(player.method_73189(), 8))
            return false;
        if (heldControls.contains(5))
            return false;

        class_3501 info = contraption.getBlocks().get(controlsLocalPos);
        class_2350 initialOrientation = getInitialOrientation().method_10160();
        boolean inverted = false;
        if (info != null && info.comp_1342().method_28498(ControlsBlock.field_11177))
            inverted = !info.comp_1342().method_11654(ControlsBlock.field_11177).equals(initialOrientation);

        if (hudPacketCooldown-- <= 0 && player instanceof class_3222 sp) {
            sp.field_13987.method_14364(new TrainHUDControlUpdatePacket(carriage.train));
            hudPacketCooldown = 5;
        }

        int targetSpeed = 0;
        if (heldControls.contains(0))
            targetSpeed++;
        if (heldControls.contains(1))
            targetSpeed--;

        int targetSteer = 0;
        if (heldControls.contains(2))
            targetSteer++;
        if (heldControls.contains(3))
            targetSteer--;

        if (inverted) {
            targetSpeed *= -1;
            targetSteer *= -1;
        }

        if (targetSpeed != 0)
            carriage.train.burnFuel(method_73183());

        boolean slow = inverted ^ targetSpeed < 0;
        boolean spaceDown = heldControls.contains(4);
        GlobalStation currentStation = carriage.train.getCurrentStation();
        if (currentStation != null && spaceDown) {
            sendPrompt(player, class_2561.method_43469("create.train.arrived_at", class_2561.method_43470(currentStation.name).method_54663(0x704630)), false);
            return true;
        }

        if (carriage.train.speedBeforeStall != null && targetSpeed != 0 && Math.signum(carriage.train.speedBeforeStall) != Math.signum(targetSpeed)) {
            carriage.train.cancelStall();
        }

        if (currentStation != null && targetSpeed != 0) {
            stationMessage = false;
            sendPrompt(player, class_2561.method_43469("create.train.departing_from", class_2561.method_43470(currentStation.name).method_54663(0x704630)), false);
        }

        if (currentStation == null) {

            Navigation nav = carriage.train.navigation;
            if (nav.destination != null) {
                if (!spaceDown)
                    nav.cancelNavigation();
                if (spaceDown) {
                    double f = (nav.distanceToDestination / navDistanceTotal);
                    int progress = (int) (class_3532.method_15350(1 - ((1 - f) * (1 - f)), 0, 1) * 30);
                    boolean arrived = progress == 0;
                    class_5250 whiteComponent = class_2561.method_43470(Strings.repeat("|", progress));
                    class_5250 greenComponent = class_2561.method_43470(Strings.repeat("|", 30 - progress));

                    int fromColor = 0x00_FFC244;
                    int toColor = 0x00_529915;

                    int mixedColor = Color.mixColors(toColor, fromColor, progress / 30f);
                    int targetColor = arrived ? toColor : 0x00_544D45;

                    class_5250 component = greenComponent.method_54663(mixedColor).method_10852(whiteComponent.method_54663(targetColor));
                    sendPrompt(player, component, true);
                    carriage.train.manualTick = true;
                    return true;
                }
            }

            double directedSpeed = targetSpeed != 0 ? targetSpeed : carriage.train.speed;
            GlobalStation lookAhead = nav.findNearestApproachable(!carriage.train.doubleEnded || (directedSpeed != 0 ? directedSpeed > 0 : !inverted));

            if (lookAhead != null) {
                if (spaceDown) {
                    carriage.train.manualTick = true;
                    nav.startNavigation(nav.findPathTo(lookAhead, -1));
                    carriage.train.manualTick = false;
                    navDistanceTotal = nav.distanceToDestination;
                    return true;
                }
                displayApproachStationMessage(player, lookAhead);
            } else
                cleanUpApproachStationMessage(player);
        }

        carriage.train.manualSteer = targetSteer < 0 ? SteerDirection.RIGHT : targetSteer > 0 ? SteerDirection.LEFT : SteerDirection.NONE;

        double topSpeed = carriage.train.maxSpeed() * AllConfigs.server().trains.manualTrainSpeedModifier.getF();
        double cappedTopSpeed = topSpeed * carriage.train.throttle;

        if (carriage.getLeadingPoint().edge != null && carriage.getLeadingPoint().edge.isTurn() || carriage.getTrailingPoint().edge != null && carriage.getTrailingPoint().edge.isTurn())
            topSpeed = carriage.train.maxTurnSpeed();

        if (slow)
            topSpeed /= 4;
        carriage.train.targetSpeed = Math.min(topSpeed, cappedTopSpeed) * targetSpeed;

        boolean counteringAcceleration = Math.abs(Math.signum(targetSpeed) - Math.signum(carriage.train.speed)) > 1.5f;

        if (slow && !counteringAcceleration)
            carriage.train.backwardsDriver = player;

        carriage.train.manualTick = true;
        carriage.train.approachTargetSpeed(counteringAcceleration ? 2 : 1);
        return true;
    }

    private void sendPrompt(class_1657 player, class_5250 component, boolean shadow) {
        if (player instanceof class_3222 sp)
            sp.field_13987.method_14364(new TrainPromptPacket(component, shadow));
    }

    boolean stationMessage = false;

    private void displayApproachStationMessage(class_1657 player, GlobalStation station) {
        sendPrompt(player, class_2561.method_43469("create.contraption.controls.approach_station", class_2561.method_43472("key.jump"), station.name), false);
        stationMessage = true;
    }

    private void cleanUpApproachStationMessage(class_1657 player) {
        if (!stationMessage)
            return;
        player.method_7353(class_5244.field_39003, true);
        stationMessage = false;
    }

    private void updateTrackGraph() {
        if (carriage == null)
            return;
        Optional<UUID> optional = field_6011.method_12789(TRACK_GRAPH);
        if (optional.isEmpty()) {
            carriage.train.graph = null;
            carriage.train.derailed = true;
            return;
        }

        TrackGraph graph = Create.RAILWAYS.sided(method_73183()).trackNetworks.get(optional.get());
        if (graph == null)
            return;
        carriage.train.graph = graph;
        carriage.train.derailed = false;
    }

    @Override
    public boolean method_31746() {
        return false;
    }

    public Carriage getCarriage() {
        return carriage;
    }

    public void setCarriage(Carriage carriage) {
        this.carriage = carriage;
        this.trainId = carriage.train.id;
        this.carriageIndex = carriage.train.carriages.indexOf(carriage);
        if (contraption instanceof CarriageContraption cc)
            cc.swapStorageAfterAssembly(this);
        if (carriage.train.graph != null)
            field_6011.method_12778(TRACK_GRAPH, Optional.of(carriage.train.graph.id));

        DimensionalCarriageEntity dimensional = carriage.getDimensional(method_73183());
        dimensional.pivot = null;
        carriage.updateContraptionAnchors();
        dimensional.updateRenderedCutoff();
    }

    public void updateRenderedPortalCutoff() {
        if (carriage == null)
            return;

        // update portal slice
        particleSlice.clear();
        particleAvgY = 0;

        if (contraption instanceof CarriageContraption cc) {
            class_2350 forward = cc.getAssemblyDirection().method_10170();
            class_2351 axis = forward.method_10166();
            boolean x = axis == class_2351.field_11048;
            boolean flip = true;

            for (class_2338 pos : contraption.getBlocks().keySet()) {
                if (!cc.atSeam(pos))
                    continue;
                int pX = x ? pos.method_10263() : pos.method_10260();
                pX *= forward.method_10171().method_10181() * (flip ? 1 : -1);
                pos = new class_2338(pX, pos.method_10264(), 0);
                particleSlice.add(pos);
                particleAvgY += pos.method_10264();
            }

        }
        if (particleSlice.size() > 0)
            particleAvgY /= particleSlice.size();
    }
}
