package com.zurrtum.create.content.trains.entity;

import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_4076;

/**
 * Removes all Carriage entities in chunks that aren't ticking
 */
public class CarriageEntityHandler {

    public static void onEntityEnterSection(class_1297 entity, long oldPos, long newPos) {
        if (class_4076.method_18686(oldPos) == class_4076.method_18686(newPos) && class_4076.method_18690(oldPos) == class_4076.method_18690(newPos))
            return;
        if (!(entity instanceof CarriageContraptionEntity cce))
            return;
        if (!((class_3218) entity.method_73183()).method_37118(class_4076.method_18677(newPos).method_19768()))
            cce.leftTickingChunks = true;
    }

    public static void validateCarriageEntity(CarriageContraptionEntity entity) {
        if (!entity.method_5805())
            return;
        class_1937 level = entity.method_73183();
        if (level.method_8608())
            return;
        if (!isActiveChunk(level, entity.method_24515()))
            entity.leftTickingChunks = true;
    }

    public static boolean isActiveChunk(class_1937 level, class_2338 pos) {
        if (level instanceof class_3218 serverLevel)
            return serverLevel.method_37118(pos);
        return false;
    }

}
