package com.zurrtum.create.content.trains.schedule;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.trains.entity.CarriageContraption;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.content.trains.entity.Train;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class ScheduleItemEntityInteraction {
    public static class_1269 interactWithConductor(class_1297 entity, class_1657 player, class_1268 hand) {
        class_1297 rootVehicle = entity.method_5668();
        if (!(rootVehicle instanceof CarriageContraptionEntity cce))
            return null;
        if (!(entity instanceof class_1309 living))
            return null;
        class_1799 schedule = AllItems.SCHEDULE.method_7854();
        if (player.method_7357().method_7904(schedule))
            return null;

        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_7909() instanceof ScheduleItem si) {
            class_1269 result = si.handScheduleTo(itemStack, player, living, hand);
            if (result.method_23665()) {
                player.method_7357().method_62835(schedule, 5);
                return result;
            }
        }

        if (hand == class_1268.field_5810)
            return null;

        Contraption contraption = cce.getContraption();
        if (!(contraption instanceof CarriageContraption cc))
            return null;

        Train train = cce.getCarriage().train;
        if (train == null)
            return null;
        if (train.runtime.getSchedule() == null)
            return null;

        Integer seatIndex = contraption.getSeatMapping().get(entity.method_5667());
        if (seatIndex == null)
            return null;
        class_2338 seatPos = contraption.getSeats().get(seatIndex);
        Couple<Boolean> directions = cc.conductorSeats.get(seatPos);
        if (directions == null)
            return null;

        class_1937 world = player.method_73183();
        boolean onServer = !world.method_8608();

        if (train.runtime.paused && !train.runtime.completed) {
            if (onServer) {
                train.runtime.paused = false;
                AllSoundEvents.CONFIRM.playOnServer(world, player.method_24515(), 1, 1);
                player.method_7353(class_2561.method_43471("create.schedule.continued"), true);
            }

            player.method_7357().method_62835(schedule, 5);
            return class_1269.field_5812;
        }

        if (!itemStack.method_7960()) {
            if (onServer) {
                AllSoundEvents.DENY.playOnServer(world, player.method_24515(), 1, 1);
                player.method_7353(class_2561.method_43471("create.schedule.remove_with_empty_hand"), true);
            }
            return class_1269.field_5812;
        }

        if (onServer) {
            world.method_8396(null, player.method_24515(), class_3417.field_15197, class_3419.field_15248, .2f, 1f + world.field_9229.method_43057());
            player.method_7353(
                class_2561.method_43471(train.runtime.isAutoSchedule ? "create.schedule.auto_removed_from_train" : "create.schedule.removed_from_train"),
                true
            );

            player.method_31548().method_7398(train.runtime.returnSchedule(player.method_56673()));
        }

        player.method_7357().method_62835(schedule, 5);
        return class_1269.field_5812;
    }
}