package com.zurrtum.create.foundation.blockEntity.behaviour.animatedContainer;

import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.gui.menu.MenuBase;
import java.util.function.Consumer;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;

public class AnimatedContainerBehaviour<M extends MenuBase<? extends SmartBlockEntity>> extends BlockEntityBehaviour<SmartBlockEntity> {

    public static final BehaviourType<AnimatedContainerBehaviour<?>> TYPE = new BehaviourType<>();

    public int openCount;

    private final Class<M> menuClass;
    private Consumer<Boolean> openChanged;

    public AnimatedContainerBehaviour(SmartBlockEntity be, Class<M> menuClass) {
        super(be);
        this.menuClass = menuClass;
        openCount = 0;
    }

    public void onOpenChanged(Consumer<Boolean> openChanged) {
        this.openChanged = openChanged;
    }

    @Override
    public void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        if (clientPacket)
            openCount = view.method_71424("OpenCount", 0);
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        if (clientPacket)
            view.method_71465("OpenCount", openCount);
    }

    @Override
    public void lazyTick() {
        updateOpenCount();
        super.lazyTick();
    }

    void updateOpenCount() {
        class_1937 level = getWorld();
        if (level.method_8608())
            return;
        if (openCount == 0)
            return;

        int prevOpenCount = openCount;
        openCount = 0;

        for (class_1657 playerentity : level.method_18467(class_1657.class, new class_238(getPos()).method_1014(8)))
            if (menuClass.isInstance(playerentity.field_7512) && menuClass.cast(playerentity.field_7512).contentHolder == blockEntity)
                openCount++;

        if (prevOpenCount != openCount) {
            if (openChanged != null && prevOpenCount == 0 && openCount > 0)
                openChanged.accept(true);
            if (openChanged != null && prevOpenCount > 0 && openCount == 0)
                openChanged.accept(false);
            blockEntity.sendData();
        }
    }

    public void startOpen(class_1657 player) {
        if (player.method_7325())
            return;
        if (getWorld().method_8608())
            return;
        if (openCount < 0)
            openCount = 0;
        openCount++;
        if (openCount == 1 && openChanged != null)
            openChanged.accept(true);
        blockEntity.sendData();
    }

    public void stopOpen(class_1657 player) {
        if (player.method_7325())
            return;
        if (getWorld().method_8608())
            return;
        openCount--;
        if (openCount == 0 && openChanged != null)
            openChanged.accept(false);
        blockEntity.sendData();
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

}
