package com.zurrtum.create.impl.unpacking;

import com.zurrtum.create.AllUnpackingHandlers;
import com.zurrtum.create.api.packager.unpacking.UnpackingHandler;
import com.zurrtum.create.content.processing.basin.BasinBlockEntity;
import com.zurrtum.create.infrastructure.component.PackageOrderWithCrafts;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class BasinUnpackingHandler implements UnpackingHandler {
    @Override
    public boolean unpack(
        class_1937 level,
        class_2338 pos,
        class_2680 state,
        class_2350 side,
        List<class_1799> items,
        @Nullable PackageOrderWithCrafts orderContext,
        boolean simulate
    ) {
        class_2586 be = level.method_8321(pos);
        if (!(be instanceof BasinBlockEntity basin))
            return false;

        basin.itemCapability.disableCheck();

        try {
            return AllUnpackingHandlers.DEFAULT.unpack(level, pos, state, side, items, orderContext, simulate);
        } finally {
            basin.itemCapability.enableCheck();
        }
    }
}
