/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.actors.psi;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.actors.psi.PortableStorageInterfaceBlockEntity;
import com.zurrtum.create.foundation.fluid.FluidTank;
import com.zurrtum.create.infrastructure.fluids.CombinedTankWrapper;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import com.zurrtum.create.infrastructure.fluids.SidedFluidInventory;
import com.zurrtum.create.infrastructure.transfer.SlotRangeCache;
import java.util.Iterator;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PortableFluidInterfaceBlockEntity
extends PortableStorageInterfaceBlockEntity {
    public final FluidInventory capability = new InterfaceFluidHandler();

    public PortableFluidInterfaceBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.PORTABLE_FLUID_INTERFACE, pos, state);
    }

    @Override
    public void startTransferringTo(Contraption contraption, float distance) {
        ((InterfaceFluidHandler)this.capability).setInventory(contraption.getStorage().getFluids());
        super.startTransferringTo(contraption, distance);
    }

    @Override
    protected void stopTransferring() {
        ((InterfaceFluidHandler)this.capability).setEmpty();
        super.stopTransferring();
    }

    public class InterfaceFluidHandler
    implements SidedFluidInventory {
        private static final FluidTank EMPTY = new FluidTank(0);
        private int[] slots = SlotRangeCache.EMPTY;
        private FluidInventory wrapped = EMPTY;

        @Override
        public int[] getAvailableSlots(class_2350 side) {
            return this.slots;
        }

        @Override
        public boolean canExtract(int slot, FluidStack stack, class_2350 dir) {
            if (this.wrapped == EMPTY) {
                return false;
            }
            return ((SidedFluidInventory)this.wrapped).canExtract(slot, stack, dir);
        }

        @Override
        public boolean canInsert(int slot, FluidStack stack, @Nullable class_2350 dir) {
            if (this.wrapped == EMPTY) {
                return false;
            }
            return ((SidedFluidInventory)this.wrapped).canInsert(slot, stack, dir);
        }

        public void setInventory(CombinedTankWrapper wrapped) {
            this.wrapped = wrapped;
            this.slots = wrapped.getAvailableSlots(null);
        }

        public void setEmpty() {
            this.wrapped = EMPTY;
            this.slots = SlotRangeCache.EMPTY;
        }

        @Override
        public int size() {
            return this.slots.length;
        }

        @Override
        public int getMaxAmountPerStack() {
            return this.wrapped.getMaxAmountPerStack();
        }

        @Override
        public int getMaxAmount(FluidStack stack) {
            return this.wrapped.getMaxAmount(stack);
        }

        @Override
        public FluidStack getStack(int slot) {
            return this.wrapped.getStack(slot);
        }

        @Override
        public void setStack(int slot, FluidStack stack) {
            this.wrapped.setStack(slot, stack);
        }

        @Override
        public int insert(FluidStack stack, int maxAmount, class_2350 side) {
            int insert = this.wrapped.insert(stack, maxAmount, side);
            if (insert != 0) {
                this.markDirty();
            }
            return insert;
        }

        @Override
        public int extract(FluidStack stack, int maxAmount, class_2350 side) {
            int extract = this.wrapped.extract(stack, maxAmount, side);
            if (extract != 0) {
                this.markDirty();
            }
            return extract;
        }

        @Override
        public void markDirty() {
            PortableFluidInterfaceBlockEntity.this.onContentTransferred();
        }

        @Override
        @NotNull
        public Iterator<FluidStack> iterator(class_2350 side) {
            return this.wrapped.iterator(side);
        }
    }
}

