/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.station;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllMapDecorationTypes;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.content.trains.station.StationMapData;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1922;
import net.minecraft.class_20;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_8824;

public class StationMarker {
    public static final Codec<StationMarker> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2338.field_25064.fieldOf("source").forGetter(StationMarker::getSource), (App)class_2338.field_25064.fieldOf("target").forGetter(StationMarker::getTarget), (App)class_8824.field_46597.fieldOf("name").forGetter(StationMarker::getName)).apply((Applicative)instance, StationMarker::new));
    public static final Codec<List<StationMarker>> LIST_CODEC = CODEC.listOf();
    private final class_2338 source;
    private final class_2338 target;
    private final class_2561 name;
    private final String id;

    public StationMarker(class_2338 source, class_2338 target, class_2561 name) {
        this.source = source;
        this.target = target;
        this.name = name;
        this.id = "create:station-" + target.method_10263() + "," + target.method_10264() + "," + target.method_10260();
    }

    public static StationMarker fromWorld(class_1922 level, class_2338 pos) {
        Optional stationOption = level.method_35230(pos, AllBlockEntityTypes.TRACK_STATION);
        if (stationOption.isEmpty() || ((StationBlockEntity)stationOption.get()).getStation() == null) {
            return null;
        }
        String name = ((StationBlockEntity)stationOption.get()).getStation().name;
        return new StationMarker(pos, BlockEntityBehaviour.get((class_2586)stationOption.get(), TrackTargetingBehaviour.TYPE).getPositionForMapMarker(), (class_2561)class_2561.method_43470((String)name));
    }

    public class_2338 getSource() {
        return this.source;
    }

    public class_2338 getTarget() {
        return this.target;
    }

    public class_2561 getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StationMarker that = (StationMarker)o;
        if (!this.target.equals((Object)that.target)) {
            return false;
        }
        return this.name.equals((Object)that.name);
    }

    public int hashCode() {
        return Objects.hash(this.target, this.name);
    }

    public static class_20 createStationDecoration(byte x, byte y, Optional<class_2561> name) {
        return new class_20(AllMapDecorationTypes.STATION_MAP_DECORATION, x, y, 0, name);
    }

    public record WrapperCodec(Codec<class_22> codec) implements Codec<class_22>
    {
        private static final String STATION_MARKERS_KEY = "create:stations";
        private static WrapperCodec CODEC;

        public static WrapperCodec get(Codec<class_22> codec) {
            if (CODEC == null) {
                CODEC = new WrapperCodec(codec);
            }
            return CODEC;
        }

        public <T> DataResult<Pair<class_22, T>> decode(DynamicOps<T> ops, T input) {
            return this.codec.decode(ops, input).map(pair -> {
                LIST_CODEC.parse(ops, ((MapLike)ops.getMap(input).getOrThrow()).get(STATION_MARKERS_KEY)).ifSuccess(list -> list.forEach(((StationMapData)pair.getFirst())::create$addStationMarker));
                return pair;
            });
        }

        public <T> DataResult<T> encode(class_22 input, DynamicOps<T> ops, T prefix) {
            return this.codec.encode((Object)input, ops, prefix).flatMap(result -> {
                RecordBuilder map = ops.mapBuilder();
                map.add(STATION_MARKERS_KEY, ((StationMapData)input).create$getStationMarkers().values().stream().toList(), LIST_CODEC);
                return map.build(result);
            });
        }
    }
}

