package com.zurrtum.create;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.infrastructure.particle.*;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

import static com.zurrtum.create.Create.MOD_ID;

public class AllParticleTypes {
    public static final class_2396<RotationIndicatorParticleData> ROTATION_INDICATOR = register(
        "rotation_indicator",
        RotationIndicatorParticleData.CODEC,
        RotationIndicatorParticleData.STREAM_CODEC
    );
    public static final class_2396<AirFlowParticleData> AIR_FLOW = register(
        "air_flow",
        AirFlowParticleData.CODEC,
        AirFlowParticleData.STREAM_CODEC
    );
    public static final class_2396<AirParticleData> AIR = register("air", AirParticleData.CODEC, AirParticleData.STREAM_CODEC);
    public static final class_2400 STEAM_JET = register("steam_jet");
    public static final class_2396<CubeParticleData> CUBE = register("cube", CubeParticleData.CODEC, CubeParticleData.STREAM_CODEC);
    public static final class_2396<FluidParticleData> FLUID_PARTICLE = register(
        "fluid_particle",
        FluidParticleData.CODEC,
        FluidParticleData.STREAM_CODEC
    );
    public static final class_2396<FluidParticleData> BASIN_FLUID = register(
        "basin_fluid",
        FluidParticleData.BASIN_CODEC,
        FluidParticleData.BASIN_STREAM_CODEC
    );
    public static final class_2396<FluidParticleData> FLUID_DRIP = register(
        "fluid_drip",
        FluidParticleData.DRIP_CODEC,
        FluidParticleData.DRIP_STREAM_CODEC
    );
    public static final class_2400 WIFI = register("wifi");
    public static final class_2400 SOUL = register("soul");
    public static final class_2400 SOUL_BASE = register("soul_base");
    public static final class_2400 SOUL_PERIMETER = register("soul_perimeter");
    public static final class_2400 SOUL_EXPANDING_PERIMETER = register("soul_expanding_perimeter");

    private static class_2400 register(String name) {
        class_2960 id = class_2960.method_60655(MOD_ID, name);
        return class_2378.method_10230(class_7923.field_41180, id, new class_2400(false));
    }

    private static <T extends class_2394> class_2396<T> register(
        String name,
        MapCodec<T> codec,
        class_9139<? super class_9129, T> packetCodec
    ) {
        class_2396<T> type = new class_2396<T>(false) {
            public MapCodec<T> method_29138() {
                return codec;
            }

            public class_9139<? super class_9129, T> method_56179() {
                return packetCodec;
            }
        };
        return class_2378.method_10230(class_7923.field_41180, class_2960.method_60655(MOD_ID, name), type);
    }

    public static void register() {
    }
}
