package com.zurrtum.create.api.contraption.dispenser;

import com.zurrtum.create.api.contraption.storage.item.MountedItemStorage;
import com.zurrtum.create.api.registry.SimpleRegistry;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.impl.contraption.dispenser.DispenserBehaviorConverter;
import net.minecraft.class_1263;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_243;

/**
 * A parallel to {@link class_2357}, for use by mounted dispensers.
 * Create will attempt to wrap existing {@link class_2357}s, but this interface can be used to provide better or fixed behavior.
 *
 * @see DefaultMountedDispenseBehavior
 * @see MountedProjectileDispenseBehavior
 * @see OptionalMountedDispenseBehavior
 */
@FunctionalInterface
public interface MountedDispenseBehavior {
    SimpleRegistry<class_1792, MountedDispenseBehavior> REGISTRY = class_156.method_656(() -> {
        SimpleRegistry<class_1792, MountedDispenseBehavior> registry = SimpleRegistry.create();
        registry.registerProvider(DispenserBehaviorConverter.INSTANCE);
        return registry;
    });

    /**
     * Dispense the given stack into the world.
     *
     * @param stack   the stack to dispense. Safe to modify, behaviors are given a copy
     * @param context the MovementContext of the dispenser
     * @param pos     the BlockPos being visited by the dispenser
     * @return the remaining stack after dispensing one item
     */
    class_1799 dispense(class_1799 stack, MovementContext context, class_2338 pos);

    // utilities for implementations

    static class_243 getDispenserNormal(MovementContext ctx) {
        class_2350 facing = ctx.state.method_11654(class_2315.field_10918);
        class_243 normal = class_243.method_24954(facing.method_62675());
        return ctx.rotation.apply(normal).method_1029();
    }

    static class_2350 getClosestFacingDirection(class_243 facing) {
        return class_2350.method_10142(facing.field_1352, facing.field_1351, facing.field_1350);
    }

    /**
     * Attempt to place an item back into the inventory. This is used in the case of item overflow, such as a stack
     * of buckets becoming two separate stacks when one is filled with water.
     * <p>
     * First tries to insert directly into the dispenser inventory. If that fails, it then tries the contraption's
     * whole inventory. If that still fails, the stack is dispensed into the world with the default behavior.
     *
     * @param stack   the stack to store in the inventory
     * @param context the MovementContext given to the behavior
     * @param pos     the position given to the behavior
     */
    static void placeItemInInventory(class_1799 stack, MovementContext context, class_2338 pos) {
        int count = stack.method_7947();
        if (count == 0) {
            return;
        }
        class_1799 toInsert = stack.method_7972();
        // try inserting into own inventory first
        MountedItemStorage storage = context.getItemStorage();
        int insert;
        if (storage != null) {
            insert = storage.insert(toInsert);
            if (insert == count) {
                return;
            }
            if (insert > 0) {
                count -= insert;
                toInsert.method_7939(count);
            }
        }
        // next, try the whole contraption inventory
        class_1263 contraption = context.contraption.getStorage().getAllItems();
        insert = contraption.insert(toInsert);
        if (insert == count) {
            return;
        }
        if (insert > 0) {
            toInsert.method_7939(count - insert);
        }
        // if there's *still* something left, dispense into world
        DefaultMountedDispenseBehavior.INSTANCE.dispense(toInsert, context, pos);
    }
}
