package com.zurrtum.create.api.contraption.storage.item;

import com.mojang.serialization.Codec;
import com.zurrtum.create.api.contraption.storage.item.menu.MountedStorageMenus;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.infrastructure.items.ItemInventory;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_11565;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3499.class_3501;
import net.minecraft.class_3908;
import net.minecraft.class_5250;
import net.minecraft.class_6903;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public abstract class MountedItemStorage implements ItemInventory {
    public static final Codec<MountedItemStorage> CODEC = MountedItemStorageType.CODEC.dispatch(storage -> storage.type, type -> type.codec);

    @SuppressWarnings("deprecation")
    public static final class_9139<class_9129, MountedItemStorage> STREAM_CODEC = class_9139.method_56438(
        (b, t) -> t.method_29172(
            class_6903.method_46632(
                class_2509.field_11560,
                t.method_56349()
            ), CODEC, b
        ),
        b -> b.method_52954(class_6903.method_46632(class_2509.field_11560, b.method_56349()), CODEC)
    );

    public final MountedItemStorageType<? extends MountedItemStorage> type;

    protected MountedItemStorage(MountedItemStorageType<?> type) {
        this.type = Objects.requireNonNull(type);
    }

    /**
     * Un-mount this storage back into the world. The expected storage type of the target
     * block has already been checked to make sure it matches this storage's type.
     */
    public abstract void unmount(class_1937 level, class_2680 state, class_2338 pos, @Nullable class_2586 be);

    /**
     * Handle a player clicking on this mounted storage. This is always called on the server.
     * The default implementation will try to open a generic GUI for standard inventories.
     * For this to work, this storage must have 1-6 complete rows of 9 slots.
     *
     * @return true if the interaction was successful
     */
    public boolean handleInteraction(class_3222 player, Contraption contraption, class_3501 info) {
        class_3218 level = player.method_51469();
        class_2338 localPos = info.comp_1341();
        class_243 localPosVec = class_243.method_24953(localPos);
        Predicate<class_1657> stillValid = p -> {
            class_243 currentPos = contraption.entity.toGlobalVector(localPosVec, 0);
            return this.isMenuValid(player, contraption, currentPos);
        };
        class_2561 menuName = this.getMenuName(info, contraption);
        class_1263 handler = this.getHandlerForMenu(info, contraption);
        Consumer<class_11565> onClose = p -> {
            class_243 newPos = contraption.entity.toGlobalVector(localPosVec, 0);
            this.playClosingSound(level, newPos);
        };

        OptionalInt id = player.method_17355(this.createMenuProvider(menuName, handler, stillValid, onClose));
        if (id.isPresent()) {
            class_243 globalPos = contraption.entity.toGlobalVector(localPosVec, 0);
            this.playOpeningSound(level, globalPos);
            return true;
        } else {
            return false;
        }
    }

    /**
     * Get the item handler that will be used by this storage's menu. This is useful for
     * handling multi-blocks, such as double chests.
     */
    protected class_1263 getHandlerForMenu(class_3501 info, Contraption contraption) {
        return this;
    }

    /**
     * @param player the player who opened the menu
     * @param pos    the center of this storage in-world
     * @return true if a GUI opened for this storage is still valid
     */
    protected boolean isMenuValid(class_3222 player, Contraption contraption, class_243 pos) {
        return contraption.entity.method_5805() && player.method_5707(pos) < (8 * 8);
    }

    /**
     * @return the title to be shown in the GUI when this storage is opened
     */
    protected class_2561 getMenuName(class_3501 info, Contraption contraption) {
        class_5250 blockName = info.comp_1342().method_26204().method_9518();
        return class_2561.method_43469("create.contraptions.moving_container", blockName);
    }

    /**
     * @return a MenuProvider that provides the menu players will see when opening this storage
     */
    @Nullable
    protected class_3908 createMenuProvider(
        class_2561 name,
        class_1263 handler,
        Predicate<class_1657> stillValid,
        Consumer<class_11565> onClose
    ) {
        return MountedStorageMenus.createGeneric(name, handler, stillValid, onClose);
    }

    /**
     * Play the sound made by opening this storage's GUI.
     */
    protected void playOpeningSound(class_3218 level, class_243 pos) {
        level.method_8396(null, class_2338.method_49638(pos), class_3417.field_17604, class_3419.field_15245, 0.75f, 1f);
    }

    /**
     * Play the sound made by closing this storage's GUI.
     */
    protected void playClosingSound(class_3218 level, class_243 pos) {
    }
}