package com.zurrtum.create.api.contraption.storage.item.simple;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllMountedStorageTypes;
import com.zurrtum.create.api.contraption.storage.item.MountedItemStorageType;
import com.zurrtum.create.api.contraption.storage.item.WrapperMountedItemStorage;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1263;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

/**
 * Widely-applicable mounted storage implementation.
 * Gets an item handler from the mounted block, copies it to an ItemStackHandler,
 * and then copies the inventory back to the target when unmounting.
 * All blocks for which this mounted storage is registered must provide an
 * {@link class_1263} to {@link ItemInventoryProvider}.
 * <br>
 * To use this implementation, either register {@link AllMountedStorageTypes#SIMPLE} to your block
 * manually, or add your block to the {@link AllBlockTags#SIMPLE_MOUNTED_STORAGE} tag.
 * It is also possible to extend this class to create your own implementation.
 */
public class SimpleMountedStorage extends WrapperMountedItemStorage<ItemStackHandler> {
    public static final MapCodec<SimpleMountedStorage> CODEC = codec(SimpleMountedStorage::new);

    public SimpleMountedStorage(MountedItemStorageType<?> type, class_1263 handler) {
        super(type, copyToItemStackHandler(handler));
    }

    public SimpleMountedStorage(class_1263 handler) {
        this(AllMountedStorageTypes.SIMPLE, handler);
    }

    @Override
    public void unmount(class_1937 level, class_2680 state, class_2338 pos, @Nullable class_2586 be) {
        if (be == null)
            return;

        class_1263 cap = ItemHelper.getInventory(level, pos, state, be, null);
        if (cap != null) {
            validate(cap).ifPresent(handler -> {
                for (int i = 0, size = handler.method_5439(); i < size; i++) {
                    handler.method_5447(i, method_5438(i));
                }
            });
        }
    }

    /**
     * Make sure the targeted handler is valid for copying items back into.
     * It is highly recommended to call super in overrides.
     */
    protected Optional<class_1263> validate(class_1263 handler) {
        if (handler.method_5439() == this.method_5439()) {
            return Optional.of(handler);
        } else {
            return Optional.empty();
        }
    }

    public static <T extends SimpleMountedStorage> MapCodec<T> codec(Function<class_1263, T> factory) {
        return CreateCodecs.ITEM_STACK_HANDLER.xmap(factory, storage -> storage.wrapped).fieldOf("value");
    }
}
