package com.zurrtum.create.api.contraption.storage.item.simple;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.api.contraption.storage.item.MountedItemStorageType;
import com.zurrtum.create.foundation.item.ItemHelper;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public abstract class SimpleMountedStorageType<T extends SimpleMountedStorage> extends MountedItemStorageType<T> {
    protected SimpleMountedStorageType(MapCodec<T> codec) {
        super(codec);
    }

    @Override
    @Nullable
    public T mount(class_1937 level, class_2680 state, class_2338 pos, @Nullable class_2586 be) {
        return Optional.ofNullable(be).map(b -> getHandler(level, b)).map(this::createStorage).orElse(null);
    }

    protected class_1263 getHandler(class_1937 level, class_2586 be) {
        return ItemHelper.getInventory(level, be.method_11016(), null, be, null);
    }

    protected abstract T createStorage(class_1263 handler);

    public static final class Impl extends SimpleMountedStorageType<SimpleMountedStorage> {
        public Impl() {
            super(SimpleMountedStorage.CODEC);
        }

        @Override
        protected SimpleMountedStorage createStorage(class_1263 handler) {
            return new SimpleMountedStorage(this, handler);
        }
    }
}
