package com.zurrtum.create.api.schematic.nbt;

import com.zurrtum.create.api.registry.SimpleRegistry;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_7225;

/**
 * Registry for safe NBT writers, used for filtering unsafe BlockEntity data out of schematics.
 * <p>
 * This is used to exclude specific tags that would result in exploits, ex. signs that execute commands when clicked.
 * <p>
 * This is provided as an alternative to {@link PartialSafeNBT}.
 */
public class SafeNbtWriterRegistry {
    public static final SimpleRegistry<class_2591<?>, SafeNbtWriter> REGISTRY = SimpleRegistry.create();

    @FunctionalInterface
    public interface SafeNbtWriter {
        /**
         * Write filtered, safe NBT to the given tag. This is always called on the logical server.
         *
         * @param tag the NBT tag to write to
         */
        void writeSafe(class_2586 be, class_2487 tag, class_7225.class_7874 registries);
    }

    private SafeNbtWriterRegistry() {
        throw new AssertionError("This class should not be instantiated");
    }
}
