package com.zurrtum.create.catnip.codecs.stream;

import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;

import java.util.function.Function;
import net.minecraft.class_1268;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import net.minecraft.class_3965;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public interface CatnipStreamCodecs {
    class_9139<class_2540, Character> CHAR = new class_9139<>() {
        public @NotNull Character decode(class_2540 buffer) {
            return buffer.readChar();
        }

        public void encode(class_2540 buffer, @NotNull Character value) {
            buffer.method_53004(value);
        }
    };
    class_9139<class_9129, class_6880<class_3611>> HOLDER_FLUID = class_9135.method_56383(class_7924.field_41270);
    class_9139<class_9129, class_3611> FLUID = class_9135.method_56365(class_7924.field_41270);
    class_9139<ByteBuf, class_2520> COMPOUND_AS_TAG = class_9135.field_48556.method_56432(Function.identity(), tag -> (class_2487) tag);
    class_9139<class_2540, class_2499> COMPOUND_LIST_TAG = new class_9139<>() {
        @Override
        public @NotNull class_2499 decode(class_2540 buffer) {
            return buffer.method_34068(size -> new class_2499(), COMPOUND_AS_TAG);
        }

        @Override
        public void encode(class_2540 buffer, class_2499 value) {
            buffer.method_34062(value, COMPOUND_AS_TAG);
        }
    };
    class_9139<ByteBuf, class_2680> BLOCK_STATE = class_9135.method_56371(class_2248.field_10651);
    class_9139<ByteBuf, class_2338> NULLABLE_BLOCK_POS = CatnipStreamCodecBuilders.nullable(class_2338.field_48404);
    class_9139<ByteBuf, class_2350.class_2351> AXIS = CatnipStreamCodecBuilders.ofEnum(class_2350.class_2351.class);
    class_9139<ByteBuf, class_2415> MIRROR = CatnipStreamCodecBuilders.ofEnum(class_2415.class);

    // optimization: 2 values, use bool instead of ofEnum
    class_9139<ByteBuf, class_1268> HAND = class_9135.field_48547.method_56432(value -> value ? class_1268.field_5808 : class_1268.field_5810, hand -> hand == class_1268.field_5808);

    class_9139<class_2540, class_3965> BLOCK_HIT_RESULT = class_9139.method_56906(
        class_9135.field_48547,
        i -> i.method_17783() == class_239.class_240.field_1333,
        class_243.field_52694,
        class_239::method_17784,
        class_2350.field_48450,
        class_3965::method_17780,
        class_2338.field_48404,
        class_3965::method_17777,
        class_9135.field_48547,
        class_3965::method_17781,
        (miss, location, direction, blockPos, isInside) -> miss ? class_3965.method_17778(location, direction, blockPos) : new class_3965(
            location,
            direction,
            blockPos,
            isInside
        )
    );
}
