package com.zurrtum.create.catnip.math;

import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2540;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.util.math.*;
import org.jetbrains.annotations.Nullable;

public class VecHelper {
    public static final class_243 CENTER_OF_ORIGIN = new class_243(.5, .5, .5);

    public static class_243 rotate(class_243 vec, class_243 rotationVec) {
        return rotate(vec, rotationVec.field_1352, rotationVec.field_1351, rotationVec.field_1350);
    }

    public static class_243 rotate(class_243 vec, double xRot, double yRot, double zRot) {
        return rotate(rotate(rotate(vec, xRot, class_2351.field_11048), yRot, class_2351.field_11052), zRot, class_2351.field_11051);
    }

    public static class_243 rotateCentered(class_243 vec, double deg, class_2351 axis) {
        class_243 shift = getCenterOf(class_2338.field_11176);
        return VecHelper.rotate(vec.method_1020(shift), deg, axis).method_1019(shift);
    }

    public static class_243 rotate(class_243 vec, double deg, class_2351 axis) {
        if (deg == 0)
            return vec;
        if (vec == class_243.field_1353)
            return vec;

        float angle = (float) (deg / 180f * Math.PI);
        double sin = class_3532.method_15374(angle);
        double cos = class_3532.method_15362(angle);
        double x = vec.field_1352;
        double y = vec.field_1351;
        double z = vec.field_1350;

        if (axis == class_2351.field_11048)
            return new class_243(x, y * cos - z * sin, z * cos + y * sin);
        if (axis == class_2351.field_11052)
            return new class_243(x * cos + z * sin, y, z * cos - x * sin);
        if (axis == class_2351.field_11051)
            return new class_243(x * cos - y * sin, y * cos + x * sin, z);
        return vec;
    }

    public static class_243 mirrorCentered(class_243 vec, class_2415 mirror) {
        class_243 shift = getCenterOf(class_2338.field_11176);
        return VecHelper.mirror(vec.method_1020(shift), mirror).method_1019(shift);
    }

    public static class_243 mirror(class_243 vec, class_2415 mirror) {
        if (mirror == class_2415.field_11302)
            return vec;
        if (vec == class_243.field_1353)
            return vec;

        double x = vec.field_1352;
        double y = vec.field_1351;
        double z = vec.field_1350;

        if (mirror == class_2415.field_11300)
            return new class_243(x, y, -z);
        if (mirror == class_2415.field_11301)
            return new class_243(-x, y, z);
        return vec;
    }

    public static class_243 lookAt(class_243 vec, class_243 fwd) {
        fwd = fwd.method_1029();
        class_243 up = new class_243(0, 1, 0);
        double dot = fwd.method_1026(up);
        if (Math.abs(dot) > 1 - 1.0E-3)
            up = new class_243(0, 0, dot > 0 ? 1 : -1);
        class_243 right = fwd.method_1036(up).method_1029();
        up = right.method_1036(fwd).method_1029();
        double x = vec.field_1352 * right.field_1352 + vec.field_1351 * up.field_1352 + vec.field_1350 * fwd.field_1352;
        double y = vec.field_1352 * right.field_1351 + vec.field_1351 * up.field_1351 + vec.field_1350 * fwd.field_1351;
        double z = vec.field_1352 * right.field_1350 + vec.field_1351 * up.field_1350 + vec.field_1350 * fwd.field_1350;
        return new class_243(x, y, z);
    }

    public static boolean isVecPointingTowards(class_243 vec, class_2350 direction) {
        return class_243.method_24954(direction.method_62675()).method_1026(vec.method_1029()) > 0.125; // slight tolerance to activate perpendicular movement actors
    }

    public static class_243 getCenterOf(class_2382 pos) {
        if (pos.equals(class_2382.field_11176))
            return CENTER_OF_ORIGIN;
        return class_243.method_24954(pos).method_1031(.5f, .5f, .5f);
    }

    public static class_243 offsetRandomly(class_243 vec, class_5819 r, float radius) {
        return new class_243(
            vec.field_1352 + (r.method_43057() - .5f) * 2 * radius,
            vec.field_1351 + (r.method_43057() - .5f) * 2 * radius,
            vec.field_1350 + (r.method_43057() - .5f) * 2 * radius
        );
    }

    public static class_243 axisAlingedPlaneOf(class_243 vec) {
        vec = vec.method_1029();
        return new class_243(1, 1, 1).method_1023(Math.abs(vec.field_1352), Math.abs(vec.field_1351), Math.abs(vec.field_1350));
    }

    public static class_243 axisAlingedPlaneOf(class_2350 face) {
        return axisAlingedPlaneOf(class_243.method_24954(face.method_62675()));
    }

    public static class_2499 writeNBT(class_243 vec) {
        class_2499 listnbt = new class_2499();
        listnbt.add(class_2489.method_23241(vec.field_1352));
        listnbt.add(class_2489.method_23241(vec.field_1351));
        listnbt.add(class_2489.method_23241(vec.field_1350));
        return listnbt;
    }

    public static class_2487 writeNBTCompound(class_243 vec) {
        class_2487 compoundTag = new class_2487();
        compoundTag.method_10566("V", writeNBT(vec));
        return compoundTag;
    }

    public static class_243 readNBT(class_2499 list) {
        if (list.isEmpty())
            return class_243.field_1353;
        return new class_243(list.method_68574(0, 0), list.method_68574(1, 0), list.method_68574(2, 0));
    }

    public static class_243 readNBTCompound(class_2487 nbt) {
        return readNBT(nbt.method_68569("V"));
    }

    public static void write(class_243 vec, class_2540 buffer) {
        buffer.method_52940(vec.field_1352);
        buffer.method_52940(vec.field_1351);
        buffer.method_52940(vec.field_1350);
    }

    public static class_243 read(class_2540 buffer) {
        return new class_243(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
    }

    public static class_243 voxelSpace(double x, double y, double z) {
        return new class_243(x, y, z).method_1021(1 / 16f);
    }

    public static int getCoordinate(class_2382 pos, class_2351 axis) {
        return axis.method_10173(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public static float getCoordinate(class_243 vec, class_2351 axis) {
        return (float) axis.method_10172(vec.field_1352, vec.field_1351, vec.field_1350);
    }

    public static boolean onSameAxis(class_2338 pos1, class_2338 pos2, class_2351 axis) {
        if (pos1.equals(pos2))
            return true;
        for (class_2351 otherAxis : class_2351.values())
            if (axis != otherAxis)
                if (getCoordinate(pos1, otherAxis) != getCoordinate(pos2, otherAxis))
                    return false;
        return true;
    }

    public static class_243 clamp(class_243 vec, float maxLength) {
        return vec.method_1027() > maxLength * maxLength ? vec.method_1029().method_1021(maxLength) : vec;
    }

    public static class_243 lerp(float p, class_243 from, class_243 to) {
        return from.method_1019(to.method_1020(from).method_1021(p));
    }

    public static class_243 slerp(float p, class_243 from, class_243 to) {
        double theta = Math.acos(from.method_1026(to));
        return from.method_1021(class_3532.method_15374(1 - p) * theta).method_1019(to.method_1021(class_3532.method_15374((float) (theta * p))))
            .method_1021(1 / class_3532.method_15374((float) theta));
    }

    public static class_243 clampComponentWise(class_243 vec, float maxLength) {
        return new class_243(
            class_3532.method_15350(vec.field_1352, -maxLength, maxLength),
            class_3532.method_15350(vec.field_1351, -maxLength, maxLength),
            class_3532.method_15350(vec.field_1350, -maxLength, maxLength)
        );
    }

    public static class_243 componentMin(class_243 vec1, class_243 vec2) {
        return new class_243(Math.min(vec1.field_1352, vec2.field_1352), Math.min(vec1.field_1351, vec2.field_1351), Math.min(vec1.field_1350, vec2.field_1350));
    }

    public static class_243 componentMax(class_243 vec1, class_243 vec2) {
        return new class_243(Math.max(vec1.field_1352, vec2.field_1352), Math.max(vec1.field_1351, vec2.field_1351), Math.max(vec1.field_1350, vec2.field_1350));
    }

    public static class_243 project(class_243 vec, class_243 ontoVec) {
        if (ontoVec.equals(class_243.field_1353))
            return class_243.field_1353;
        return ontoVec.method_1021(vec.method_1026(ontoVec) / ontoVec.method_1027());
    }

    @Nullable
    public static class_243 intersectSphere(class_243 origin, class_243 lineDirection, class_243 sphereCenter, double radius) {
        if (lineDirection.equals(class_243.field_1353))
            return null;
        if (lineDirection.method_1027() != 1)
            lineDirection = lineDirection.method_1029();

        class_243 diff = origin.method_1020(sphereCenter);
        double lineDotDiff = lineDirection.method_1026(diff);
        double delta = lineDotDiff * lineDotDiff - (diff.method_1027() - radius * radius);
        if (delta < 0)
            return null;
        double t = -lineDotDiff + Math.sqrt(delta);
        return origin.method_1019(lineDirection.method_1021(t));
    }

    public static class_243 bezier(class_243 p1, class_243 p2, class_243 q1, class_243 q2, float t) {
        class_243 v1 = lerp(t, p1, q1);
        class_243 v2 = lerp(t, q1, q2);
        class_243 v3 = lerp(t, q2, p2);
        class_243 inner1 = lerp(t, v1, v2);
        class_243 inner2 = lerp(t, v2, v3);
        return lerp(t, inner1, inner2);
    }

    public static class_243 bezierDerivative(class_243 p1, class_243 p2, class_243 q1, class_243 q2, float t) {
        return p1.method_1021(-3 * t * t + 6 * t - 3).method_1019(q1.method_1021(9 * t * t - 12 * t + 3)).method_1019(q2.method_1021(-9 * t * t + 6 * t))
            .method_1019(p2.method_1021(3 * t * t));
    }

    public static double @Nullable [] intersectRanged(class_243 p1, class_243 q1, class_243 p2, class_243 q2, class_2351 plane) {
        class_243 pDiff = p2.method_1020(p1);
        class_243 qDiff = q2.method_1020(q1);
        double[] intersect = intersect(p1, q1, pDiff.method_1029(), qDiff.method_1029(), plane);
        if (intersect == null)
            return null;
        if (intersect[0] < 0 || intersect[1] < 0)
            return null;
        if (intersect[0] * intersect[0] > pDiff.method_1027() || intersect[1] * intersect[1] > qDiff.method_1027())
            return null;
        return intersect;
    }

    public static double @Nullable [] intersect(class_243 p1, class_243 p2, class_243 r, class_243 s, class_2351 plane) {
        if (plane == class_2351.field_11048) {
            p1 = new class_243(p1.field_1351, 0, p1.field_1350);
            p2 = new class_243(p2.field_1351, 0, p2.field_1350);
            r = new class_243(r.field_1351, 0, r.field_1350);
            s = new class_243(s.field_1351, 0, s.field_1350);
        }

        if (plane == class_2351.field_11051) {
            p1 = new class_243(p1.field_1352, 0, p1.field_1351);
            p2 = new class_243(p2.field_1352, 0, p2.field_1351);
            r = new class_243(r.field_1352, 0, r.field_1351);
            s = new class_243(s.field_1352, 0, s.field_1351);
        }

        class_243 qminusp = p2.method_1020(p1);
        double rcs = r.field_1352 * s.field_1350 - r.field_1350 * s.field_1352;
        if (class_3532.method_20390(rcs, 0))
            return null;
        class_243 rdivrcs = r.method_1021(1 / rcs);
        class_243 sdivrcs = s.method_1021(1 / rcs);
        double t = qminusp.field_1352 * sdivrcs.field_1350 - qminusp.field_1350 * sdivrcs.field_1352;
        double u = qminusp.field_1352 * rdivrcs.field_1350 - qminusp.field_1350 * rdivrcs.field_1352;
        return new double[]{t, u};
    }

    public static double alignedDistanceToFace(class_243 pos, class_2338 blockPos, class_2350 face) {
        class_2351 axis = face.method_10166();
        return Math.abs(getCoordinate(
            pos,
            axis
        ) - (blockPos.method_30558(axis) + (face.method_10171() == class_2350.class_2352.field_11056 ? 1 : 0)));
    }
}
