package com.zurrtum.create.catnip.nbt;

import com.zurrtum.create.catnip.codecs.CatnipCodecUtils;
import com.zurrtum.create.catnip.components.ComponentProcessors;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_7923;
import net.minecraft.class_8242;
import net.minecraft.class_9331;

public final class NBTProcessors {

    private static final Map<class_2591<?>, UnaryOperator<class_2487>> processors = new HashMap<>();
    private static final Map<class_2591<?>, UnaryOperator<class_2487>> survivalProcessors = new HashMap<>();

    public static synchronized void addProcessor(class_2591<?> type, UnaryOperator<class_2487> processor) {
        processors.put(type, processor);
    }

    public static synchronized void addSurvivalProcessor(class_2591<?> type, UnaryOperator<class_2487> processor) {
        survivalProcessors.put(type, processor);
    }

    // Triggered by block tag, not BE type
    private static final UnaryOperator<class_2487> signProcessor = data -> {
        for (String key : List.of("front_text", "back_text")) {
            class_8242 text = data.method_10562(key).flatMap(k -> CatnipCodecUtils.decode(class_8242.field_43298, k)).orElse(null);
            if (text != null) {
                for (class_2561 component : text.method_49877(false)) {
                    if (textComponentHasClickEvent(component))
                        return null;
                }
            }
        }
        if (data.method_10545("front_item") || data.method_10545("back_item"))
            return null; // "Amendments" compat: sign data contains itemstacks
        return data;
    };

    public static UnaryOperator<class_2487> itemProcessor(String tagKey) {
        return data -> {
            class_2487 compound = data.method_68568(tagKey);
            if (!compound.method_10545("components"))
                return data;
            class_2487 itemComponents = compound.method_68568("components");
            HashSet<String> keys = new HashSet<>(itemComponents.method_10541());
            for (String key : keys) {
                class_9331<?> type = class_7923.field_49658.method_63535(class_2960.method_60654(key));
                if (type != null && ComponentProcessors.isUnsafeItemComponent(type))
                    itemComponents.method_10551(key);
            }
            if (itemComponents.method_33133())
                compound.method_10551("components");
            return data;
        };
    }

    public static boolean textComponentHasClickEvent(class_2561 component) {
        for (class_2561 sibling : component.method_10855()) {
            if (textComponentHasClickEvent(sibling)) {
                return true;
            }
        }
        return component.method_10866().method_10970() != null;
    }

    private NBTProcessors() {
    }

    @Nullable
    public static class_2487 process(class_2680 state, class_2586 blockEntity, @Nullable class_2487 compound, boolean survival) {
        if (compound == null)
            return null;
        class_2591<?> type = blockEntity.method_11017();
        if (survival && survivalProcessors.containsKey(type))
            compound = survivalProcessors.get(type).apply(compound);
        if (compound != null && processors.containsKey(type))
            return processors.get(type).apply(compound);
        if (blockEntity instanceof class_2636)
            return compound;
        if (state.method_26164(class_3481.field_41282))
            return signProcessor.apply(compound);
        return compound;
    }

}
