package com.zurrtum.create.client;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.client.infrastructure.model.*;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.class_10439;
import net.minecraft.class_10443;
import net.minecraft.class_1087.class_9979;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public class AllModels {
    public static final Map<class_2680, BiFunction<class_2680, class_9979, class_9979>> ALL = new HashMap<>();

    public static void register(class_2248 block, BiFunction<class_2680, class_9979, class_9979> resolver) {
        block.method_9595().method_11662().forEach(state -> {
            ALL.put(state, resolver);
        });
    }

    public static <T extends class_10439.class_10441> void register(class_2960 id, MapCodec<T> codec) {
        class_10443.field_55336.method_65325(id, codec);
    }

    public static void register() {
        register(GogglesModel.ID, GogglesModel.Unbaked.CODEC);
        register(WrenchModel.ID, WrenchModel.Unbaked.CODEC);
        register(SandPaperModel.ID, SandPaperModel.Unbaked.CODEC);
        register(ClipboardModel.ID, ClipboardModel.Unbaked.CODEC);
        register(PotatoCannonModel.ID, PotatoCannonModel.Unbaked.CODEC);
        register(ExtendoGripModel.ID, ExtendoGripModel.Unbaked.CODEC);
        register(LinkedControllerModel.ID, LinkedControllerModel.Unbaked.CODEC);
        register(CardboardSwordModel.ID, CardboardSwordModel.Unbaked.CODEC);
        register(SymmetryWandModel.ID, SymmetryWandModel.Unbaked.CODEC);
        register(WorldshaperModel.ID, WorldshaperModel.Unbaked.CODEC);
        register(OversizedModel.ID, OversizedModel.Unbaked.CODEC);
        register(TranslucentModel.ID, TranslucentModel.Unbaked.CODEC);

        BiFunction<class_2680, class_9979, class_9979> andesiteCasing = CTModel.of(AllCTBehaviours.ANDESITE_CASING);
        BiFunction<class_2680, class_9979, class_9979> brassCasing = CTModel.of(AllCTBehaviours.BRASS_CASING);
        BiFunction<class_2680, class_9979, class_9979> copperCasing = CTModel.of(AllCTBehaviours.COPPER_CASING);
        BiFunction<class_2680, class_9979, class_9979> chassis = CTModel.of(AllCTBehaviours.CHASSIS);
        BiFunction<class_2680, class_9979, class_9979> copperShingles = CTModel.of(AllCTBehaviours.COPPER_SHINGLES);
        BiFunction<class_2680, class_9979, class_9979> exposedCopperShingles = CTModel.of(AllCTBehaviours.EXPOSED_COPPER_SHINGLES);
        BiFunction<class_2680, class_9979, class_9979> weatheredCopperShingles = CTModel.of(AllCTBehaviours.WEATHERED_COPPER_SHINGLES);
        BiFunction<class_2680, class_9979, class_9979> oxidizedCopperShingles = CTModel.of(AllCTBehaviours.OXIDIZED_COPPER_SHINGLES);
        BiFunction<class_2680, class_9979, class_9979> copperTiles = CTModel.of(AllCTBehaviours.COPPER_TILES);
        BiFunction<class_2680, class_9979, class_9979> exposedcopperTiles = CTModel.of(AllCTBehaviours.EXPOSED_COPPER_TILES);
        BiFunction<class_2680, class_9979, class_9979> weatheredcopperTiles = CTModel.of(AllCTBehaviours.WEATHERED_COPPER_TILES);
        BiFunction<class_2680, class_9979, class_9979> oxidizedcopperTiles = CTModel.of(AllCTBehaviours.OXIDIZED_COPPER_TILES);
        register(AllBlocks.ANDESITE_CASING, andesiteCasing);
        register(AllBlocks.GEARBOX, andesiteCasing);
        register(AllBlocks.ANDESITE_ENCASED_SHAFT, andesiteCasing);
        register(AllBlocks.BRASS_CASING, brassCasing);
        register(AllBlocks.BRASS_ENCASED_SHAFT, brassCasing);
        register(AllBlocks.COPPER_CASING, copperCasing);
        register(AllBlocks.RAILWAY_CASING, CTModel.of(AllCTBehaviours.RAILWAY_CASING));
        register(AllBlocks.SHADOW_STEEL_CASING, CTModel.of(AllCTBehaviours.SHADOW_STEEL_CASING));
        register(AllBlocks.REFINED_RADIANCE_CASING, CTModel.of(AllCTBehaviours.REFINED_RADIANCE_CASING));
        register(AllBlocks.ANDESITE_ENCASED_COGWHEEL, CTModel.of(AllCTBehaviours.COG_SIDE_ANDESITE_CASING));
        register(AllBlocks.BRASS_ENCASED_COGWHEEL, CTModel.of(AllCTBehaviours.COG_SIDE_BRASS_CASING));
        register(AllBlocks.ANDESITE_ENCASED_LARGE_COGWHEEL, CTModel.of(AllCTBehaviours.COG_ANDESITE_CASING));
        register(AllBlocks.BRASS_ENCASED_LARGE_COGWHEEL, CTModel.of(AllCTBehaviours.COG_BRASS_CASING));
        register(AllBlocks.LINEAR_CHASSIS, chassis);
        register(AllBlocks.SECONDARY_LINEAR_CHASSIS, chassis);
        register(AllBlocks.ENCASED_FLUID_PIPE, copperCasing);
        register(AllBlocks.INDUSTRIAL_IRON_WINDOW, CTModel.of(AllCTBehaviours.INDUSTRIAL_IRON_WINDOW));
        register(AllBlocks.INDUSTRIAL_IRON_WINDOW_PANE, CTModel.of(AllCTBehaviours.INDUSTRIAL_IRON_WINDOW_PANE));
        register(AllBlocks.WEATHERED_IRON_WINDOW, CTModel.of(AllCTBehaviours.WEATHERED_IRON_WINDOW));
        register(AllBlocks.WEATHERED_IRON_WINDOW_PANE, CTModel.of(AllCTBehaviours.WEATHERED_IRON_WINDOW_PANE));
        register(AllBlocks.BRASS_TUNNEL, CTModel.of(AllCTBehaviours.BRASS_TUNNEL));
        register(AllBlocks.MECHANICAL_CRAFTER, CTModel.of(AllCTBehaviours.CRAFTER));
        register(AllBlocks.ITEM_VAULT, CTModel.of(AllCTBehaviours.ITEM_VAULT));
        register(AllBlocks.ORNATE_IRON_WINDOW, CTModel.of(AllCTBehaviours.ORNATE_IRON_WINDOW));
        register(AllBlocks.ANDESITE_SCAFFOLD, CTModel.of(AllCTBehaviours.ANDESITE_SCAFFOLD));
        register(AllBlocks.BRASS_SCAFFOLD, CTModel.of(AllCTBehaviours.BRASS_SCAFFOLD));
        register(AllBlocks.COPPER_SCAFFOLD, CTModel.of(AllCTBehaviours.COPPER_SCAFFOLD));
        register(AllBlocks.FRAMED_GLASS_TRAPDOOR, CTModel.of(AllCTBehaviours.FRAMED_GLASS_TRAPDOOR));
        register(AllBlocks.COPPER_SHINGLES, copperShingles);
        register(AllBlocks.EXPOSED_COPPER_SHINGLES, exposedCopperShingles);
        register(AllBlocks.WEATHERED_COPPER_SHINGLES, weatheredCopperShingles);
        register(AllBlocks.OXIDIZED_COPPER_SHINGLES, oxidizedCopperShingles);
        register(AllBlocks.WAXED_COPPER_SHINGLES, copperShingles);
        register(AllBlocks.WAXED_EXPOSED_COPPER_SHINGLES, exposedCopperShingles);
        register(AllBlocks.WAXED_WEATHERED_COPPER_SHINGLES, weatheredCopperShingles);
        register(AllBlocks.WAXED_OXIDIZED_COPPER_SHINGLES, oxidizedCopperShingles);
        register(AllBlocks.COPPER_SHINGLE_SLAB, copperShingles);
        register(AllBlocks.EXPOSED_COPPER_SHINGLE_SLAB, exposedCopperShingles);
        register(AllBlocks.WEATHERED_COPPER_SHINGLE_SLAB, weatheredCopperShingles);
        register(AllBlocks.OXIDIZED_COPPER_SHINGLE_SLAB, oxidizedCopperShingles);
        register(AllBlocks.WAXED_COPPER_SHINGLE_SLAB, copperShingles);
        register(AllBlocks.WAXED_EXPOSED_COPPER_SHINGLE_SLAB, exposedCopperShingles);
        register(AllBlocks.WAXED_WEATHERED_COPPER_SHINGLE_SLAB, weatheredCopperShingles);
        register(AllBlocks.WAXED_OXIDIZED_COPPER_SHINGLE_SLAB, oxidizedCopperShingles);
        register(AllBlocks.COPPER_SHINGLE_STAIRS, copperShingles);
        register(AllBlocks.EXPOSED_COPPER_SHINGLE_STAIRS, exposedCopperShingles);
        register(AllBlocks.WEATHERED_COPPER_SHINGLE_STAIRS, weatheredCopperShingles);
        register(AllBlocks.OXIDIZED_COPPER_SHINGLE_STAIRS, oxidizedCopperShingles);
        register(AllBlocks.WAXED_COPPER_SHINGLE_STAIRS, copperShingles);
        register(AllBlocks.WAXED_EXPOSED_COPPER_SHINGLE_STAIRS, exposedCopperShingles);
        register(AllBlocks.WAXED_WEATHERED_COPPER_SHINGLE_STAIRS, weatheredCopperShingles);
        register(AllBlocks.WAXED_OXIDIZED_COPPER_SHINGLE_STAIRS, oxidizedCopperShingles);
        register(AllBlocks.COPPER_TILES, copperTiles);
        register(AllBlocks.EXPOSED_COPPER_TILES, exposedcopperTiles);
        register(AllBlocks.WEATHERED_COPPER_TILES, weatheredcopperTiles);
        register(AllBlocks.OXIDIZED_COPPER_TILES, oxidizedcopperTiles);
        register(AllBlocks.WAXED_COPPER_TILES, copperTiles);
        register(AllBlocks.WAXED_EXPOSED_COPPER_TILES, exposedcopperTiles);
        register(AllBlocks.WAXED_WEATHERED_COPPER_TILES, weatheredcopperTiles);
        register(AllBlocks.WAXED_OXIDIZED_COPPER_TILES, oxidizedcopperTiles);
        register(AllBlocks.COPPER_TILE_SLAB, copperTiles);
        register(AllBlocks.EXPOSED_COPPER_TILE_SLAB, exposedcopperTiles);
        register(AllBlocks.WEATHERED_COPPER_TILE_SLAB, weatheredcopperTiles);
        register(AllBlocks.OXIDIZED_COPPER_TILE_SLAB, oxidizedcopperTiles);
        register(AllBlocks.WAXED_COPPER_TILE_SLAB, copperTiles);
        register(AllBlocks.WAXED_EXPOSED_COPPER_TILE_SLAB, exposedcopperTiles);
        register(AllBlocks.WAXED_WEATHERED_COPPER_TILE_SLAB, weatheredcopperTiles);
        register(AllBlocks.WAXED_OXIDIZED_COPPER_TILE_SLAB, oxidizedcopperTiles);
        register(AllBlocks.COPPER_TILE_STAIRS, copperTiles);
        register(AllBlocks.EXPOSED_COPPER_TILE_STAIRS, exposedcopperTiles);
        register(AllBlocks.WEATHERED_COPPER_TILE_STAIRS, weatheredcopperTiles);
        register(AllBlocks.OXIDIZED_COPPER_TILE_STAIRS, oxidizedcopperTiles);
        register(AllBlocks.WAXED_COPPER_TILE_STAIRS, copperTiles);
        register(AllBlocks.WAXED_EXPOSED_COPPER_TILE_STAIRS, exposedcopperTiles);
        register(AllBlocks.WAXED_WEATHERED_COPPER_TILE_STAIRS, weatheredcopperTiles);
        register(AllBlocks.WAXED_OXIDIZED_COPPER_TILE_STAIRS, oxidizedcopperTiles);
        register(AllBlocks.FRAMED_GLASS, CTModel.of(AllCTBehaviours.FRAMED_GLASS));
        register(AllBlocks.HORIZONTAL_FRAMED_GLASS, CTModel.of(AllCTBehaviours.HORIZONTAL_FRAMED_GLASS));
        register(AllBlocks.VERTICAL_FRAMED_GLASS, CTModel.of(AllCTBehaviours.VERTICAL_FRAMED_GLASS));
        register(AllBlocks.FRAMED_GLASS_PANE, CTModel.of(AllCTBehaviours.FRAMED_GLASS_PANE));
        register(AllBlocks.HORIZONTAL_FRAMED_GLASS_PANE, CTModel.of(AllCTBehaviours.HORIZONTAL_FRAMED_GLASS_PANE));
        register(AllBlocks.VERTICAL_FRAMED_GLASS_PANE, CTModel.of(AllCTBehaviours.VERTICAL_FRAMED_GLASS_PANE));
        register(AllBlocks.OAK_WINDOW, CTModel.of(AllCTBehaviours.OAK_WINDOW));
        register(AllBlocks.SPRUCE_WINDOW, CTModel.of(AllCTBehaviours.SPRUCE_WINDOW));
        register(AllBlocks.BIRCH_WINDOW, CTModel.of(AllCTBehaviours.BIRCH_WINDOW));
        register(AllBlocks.JUNGLE_WINDOW, CTModel.of(AllCTBehaviours.JUNGLE_WINDOW));
        register(AllBlocks.ACACIA_WINDOW, CTModel.of(AllCTBehaviours.ACACIA_WINDOW));
        register(AllBlocks.DARK_OAK_WINDOW, CTModel.of(AllCTBehaviours.DARK_OAK_WINDOW));
        register(AllBlocks.MANGROVE_WINDOW, CTModel.of(AllCTBehaviours.MANGROVE_WINDOW));
        register(AllBlocks.CRIMSON_WINDOW, CTModel.of(AllCTBehaviours.CRIMSON_WINDOW));
        register(AllBlocks.WARPED_WINDOW, CTModel.of(AllCTBehaviours.WARPED_WINDOW));
        register(AllBlocks.CHERRY_WINDOW, CTModel.of(AllCTBehaviours.CHERRY_WINDOW));
        register(AllBlocks.BAMBOO_WINDOW, CTModel.of(AllCTBehaviours.BAMBOO_WINDOW));
        register(AllBlocks.OAK_WINDOW_PANE, CTModel.of(AllCTBehaviours.OAK_WINDOW_PANE));
        register(AllBlocks.SPRUCE_WINDOW_PANE, CTModel.of(AllCTBehaviours.SPRUCE_WINDOW_PANE));
        register(AllBlocks.BIRCH_WINDOW_PANE, CTModel.of(AllCTBehaviours.BIRCH_WINDOW_PANE));
        register(AllBlocks.JUNGLE_WINDOW_PANE, CTModel.of(AllCTBehaviours.JUNGLE_WINDOW_PANE));
        register(AllBlocks.ACACIA_WINDOW_PANE, CTModel.of(AllCTBehaviours.ACACIA_WINDOW_PANE));
        register(AllBlocks.DARK_OAK_WINDOW_PANE, CTModel.of(AllCTBehaviours.DARK_OAK_WINDOW_PANE));
        register(AllBlocks.MANGROVE_WINDOW_PANE, CTModel.of(AllCTBehaviours.MANGROVE_WINDOW_PANE));
        register(AllBlocks.CRIMSON_WINDOW_PANE, CTModel.of(AllCTBehaviours.CRIMSON_WINDOW_PANE));
        register(AllBlocks.WARPED_WINDOW_PANE, CTModel.of(AllCTBehaviours.WARPED_WINDOW_PANE));
        register(AllBlocks.CHERRY_WINDOW_PANE, CTModel.of(AllCTBehaviours.CHERRY_WINDOW_PANE));
        register(AllBlocks.BAMBOO_WINDOW_PANE, CTModel.of(AllCTBehaviours.BAMBOO_WINDOW_PANE));
        register(AllBlocks.ORNATE_IRON_WINDOW_PANE, CTModel.of(AllCTBehaviours.ORNATE_IRON_WINDOW_PANE));
        register(AllBlocks.LAYERED_GRANITE, CTModel.of(AllCTBehaviours.LAYERED_GRANITE));
        register(AllBlocks.GRANITE_PILLAR, CTModel.of(AllCTBehaviours.GRANITE_PILLAR));
        register(AllBlocks.LAYERED_DIORITE, CTModel.of(AllCTBehaviours.LAYERED_DIORITE));
        register(AllBlocks.DIORITE_PILLAR, CTModel.of(AllCTBehaviours.DIORITE_PILLAR));
        register(AllBlocks.LAYERED_ANDESITE, CTModel.of(AllCTBehaviours.LAYERED_ANDESITE));
        register(AllBlocks.ANDESITE_PILLAR, CTModel.of(AllCTBehaviours.ANDESITE_PILLAR));
        register(AllBlocks.LAYERED_CALCITE, CTModel.of(AllCTBehaviours.LAYERED_CALCITE));
        register(AllBlocks.CALCITE_PILLAR, CTModel.of(AllCTBehaviours.CALCITE_PILLAR));
        register(AllBlocks.LAYERED_DRIPSTONE, CTModel.of(AllCTBehaviours.LAYERED_DRIPSTONE));
        register(AllBlocks.DRIPSTONE_PILLAR, CTModel.of(AllCTBehaviours.DRIPSTONE_PILLAR));
        register(AllBlocks.LAYERED_DEEPSLATE, CTModel.of(AllCTBehaviours.LAYERED_DEEPSLATE));
        register(AllBlocks.DEEPSLATE_PILLAR, CTModel.of(AllCTBehaviours.DEEPSLATE_PILLAR));
        register(AllBlocks.LAYERED_TUFF, CTModel.of(AllCTBehaviours.LAYERED_TUFF));
        register(AllBlocks.TUFF_PILLAR, CTModel.of(AllCTBehaviours.TUFF_PILLAR));
        register(AllBlocks.LAYERED_ASURINE, CTModel.of(AllCTBehaviours.LAYERED_ASURINE));
        register(AllBlocks.ASURINE_PILLAR, CTModel.of(AllCTBehaviours.ASURINE_PILLAR));
        register(AllBlocks.LAYERED_CRIMSITE, CTModel.of(AllCTBehaviours.LAYERED_CRIMSITE));
        register(AllBlocks.CRIMSITE_PILLAR, CTModel.of(AllCTBehaviours.CRIMSITE_PILLAR));
        register(AllBlocks.LAYERED_LIMESTONE, CTModel.of(AllCTBehaviours.LAYERED_LIMESTONE));
        register(AllBlocks.LIMESTONE_PILLAR, CTModel.of(AllCTBehaviours.LIMESTONE_PILLAR));
        register(AllBlocks.LAYERED_OCHRUM, CTModel.of(AllCTBehaviours.LAYERED_OCHRUM));
        register(AllBlocks.OCHRUM_PILLAR, CTModel.of(AllCTBehaviours.OCHRUM_PILLAR));
        register(AllBlocks.LAYERED_SCORIA, CTModel.of(AllCTBehaviours.LAYERED_SCORIA));
        register(AllBlocks.SCORIA_PILLAR, CTModel.of(AllCTBehaviours.SCORIA_PILLAR));
        register(AllBlocks.LAYERED_SCORCHIA, CTModel.of(AllCTBehaviours.LAYERED_SCORCHIA));
        register(AllBlocks.SCORCHIA_PILLAR, CTModel.of(AllCTBehaviours.SCORCHIA_PILLAR));
        register(AllBlocks.LAYERED_VERIDIUM, CTModel.of(AllCTBehaviours.LAYERED_VERIDIUM));
        register(AllBlocks.VERIDIUM_PILLAR, CTModel.of(AllCTBehaviours.VERIDIUM_PILLAR));

        register(AllBlocks.SHAFT, BracketedKineticBlockModel::new);
        register(AllBlocks.COGWHEEL, BracketedKineticBlockModel::new);
        register(AllBlocks.LARGE_COGWHEEL, BracketedKineticBlockModel::new);
        register(AllBlocks.BELT, BeltModel::new);
        register(AllBlocks.LARGE_WATER_WHEEL, LargeWaterWheelModel::new);
        register(AllBlocks.WATER_WHEEL_STRUCTURAL, WaterWheelStructuralModel::single);
        register(AllBlocks.FLUID_PIPE, PipeAttachmentModel::new);
        register(AllBlocks.ENCASED_FLUID_PIPE, PipeAttachmentModel::new);
        register(AllBlocks.GLASS_FLUID_PIPE, PipeAttachmentModel::new);
        register(AllBlocks.MECHANICAL_PUMP, PipeAttachmentModel::new);
        register(AllBlocks.FLUID_VALVE, PipeAttachmentModel::new);
        register(AllBlocks.SMART_FLUID_PIPE, PipeAttachmentModel::new);
        register(AllBlocks.FLUID_TANK, FluidTankModel::standard);
        register(AllBlocks.CREATIVE_FLUID_TANK, FluidTankModel::creative);
        register(AllBlocks.METAL_GIRDER, ConnectedGirderModel::new);
        register(AllBlocks.METAL_GIRDER_ENCASED_SHAFT, ConnectedGirderModel::new);
        register(AllBlocks.WHITE_TABLE_CLOTH, TableClothModel::new);
        register(AllBlocks.ORANGE_TABLE_CLOTH, TableClothModel::new);
        register(AllBlocks.MAGENTA_TABLE_CLOTH, TableClothModel::new);
        register(AllBlocks.LIGHT_BLUE_TABLE_CLOTH, TableClothModel::new);
        register(AllBlocks.YELLOW_TABLE_CLOTH, TableClothModel::new);
        register(AllBlocks.LIME_TABLE_CLOTH, TableClothModel::new);
        register(AllBlocks.PINK_TABLE_CLOTH, TableClothModel::new);
        register(AllBlocks.GRAY_TABLE_CLOTH, TableClothModel::new);
        register(AllBlocks.LIGHT_GRAY_TABLE_CLOTH, TableClothModel::new);
        register(AllBlocks.CYAN_TABLE_CLOTH, TableClothModel::new);
        register(AllBlocks.PURPLE_TABLE_CLOTH, TableClothModel::new);
        register(AllBlocks.BLUE_TABLE_CLOTH, TableClothModel::new);
        register(AllBlocks.BROWN_TABLE_CLOTH, TableClothModel::new);
        register(AllBlocks.GREEN_TABLE_CLOTH, TableClothModel::new);
        register(AllBlocks.RED_TABLE_CLOTH, TableClothModel::new);
        register(AllBlocks.BLACK_TABLE_CLOTH, TableClothModel::new);
        register(AllBlocks.ANDESITE_TABLE_CLOTH, TableClothModel::new);
        register(AllBlocks.BRASS_TABLE_CLOTH, TableClothModel::new);
        register(AllBlocks.COPPER_TABLE_CLOTH, TableClothModel::new);
        register(AllBlocks.FACTORY_GAUGE, FactoryPanelModel::new);
        register(AllBlocks.COPYCAT_STEP, CopycatStepModel::new);
        register(AllBlocks.COPYCAT_PANEL, CopycatPanelModel::new);

        register(AllBlocks.HAND_CRANK, EmptyModel::new);
        register(AllBlocks.COPPER_VALVE_HANDLE, EmptyModel::new);
        register(AllBlocks.WHITE_VALVE_HANDLE, EmptyModel::new);
        register(AllBlocks.ORANGE_VALVE_HANDLE, EmptyModel::new);
        register(AllBlocks.MAGENTA_VALVE_HANDLE, EmptyModel::new);
        register(AllBlocks.LIGHT_BLUE_VALVE_HANDLE, EmptyModel::new);
        register(AllBlocks.YELLOW_VALVE_HANDLE, EmptyModel::new);
        register(AllBlocks.LIME_VALVE_HANDLE, EmptyModel::new);
        register(AllBlocks.PINK_VALVE_HANDLE, EmptyModel::new);
        register(AllBlocks.GRAY_VALVE_HANDLE, EmptyModel::new);
        register(AllBlocks.LIGHT_GRAY_VALVE_HANDLE, EmptyModel::new);
        register(AllBlocks.CYAN_VALVE_HANDLE, EmptyModel::new);
        register(AllBlocks.PURPLE_VALVE_HANDLE, EmptyModel::new);
        register(AllBlocks.BLUE_VALVE_HANDLE, EmptyModel::new);
        register(AllBlocks.BROWN_VALVE_HANDLE, EmptyModel::new);
        register(AllBlocks.GREEN_VALVE_HANDLE, EmptyModel::new);
        register(AllBlocks.RED_VALVE_HANDLE, EmptyModel::new);
        register(AllBlocks.BLACK_VALVE_HANDLE, EmptyModel::new);
        register(AllBlocks.POWERED_SHAFT, EmptyModel::new);
        register(AllBlocks.GANTRY_SHAFT, EmptyModel::new);
        register(AllBlocks.TURNTABLE, EmptyModel::new);
        register(AllBlocks.CRUSHING_WHEEL, EmptyModel::new);
        register(AllBlocks.FAKE_TRACK, EmptyModel::new);
        register(AllBlocks.FLYWHEEL, EmptyModel::new);
    }
}