package com.zurrtum.create.client.catnip.ghostblock;

import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1934;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class GhostBlocks {

    private final static GhostBlocks instance = new GhostBlocks();

    public static GhostBlocks getInstance() {
        return instance;
    }

    //

    public static double getBreathingAlpha() {
        double period = 2500;
        double timer = System.currentTimeMillis() % period;
        double offset = class_3532.method_15362((float) ((2d / period) * Math.PI * timer));
        return 0.55d - 0.2d * offset;
    }

    final Map<Object, Entry> ghosts;

    public GhostBlockParams showGhostState(Object slot, class_2680 state) {
        return showGhostState(slot, state, 1);
    }

    public GhostBlockParams showGhostState(Object slot, class_2680 state, int ttl) {
        Entry e = refresh(slot, GhostBlockRenderer.transparent(), GhostBlockParams.of(state), ttl);
        return e.params;
    }

    public GhostBlockParams showGhost(Object slot, GhostBlockRenderer ghost, GhostBlockParams params, int ttl) {
        Entry e = refresh(slot, ghost, params, ttl);
        return e.params;
    }

    private Entry refresh(Object slot, GhostBlockRenderer ghost, GhostBlockParams params, int ttl) {
        if (!ghosts.containsKey(slot))
            ghosts.put(slot, new Entry(ghost, params, ttl));

        Entry e = ghosts.get(slot);
        e.ticksToLive = ttl;
        e.params = params;
        e.ghost = ghost;
        return e;
    }

    private GhostBlocks() {
        ghosts = new HashMap<>();
    }

    public void tickGhosts() {
        ghosts.forEach((slot, entry) -> entry.ticksToLive--);
        ghosts.entrySet().removeIf(e -> !e.getValue().isAlive());
    }

    public void renderAll(class_310 mc, class_4587 ms, SuperRenderTypeBuffer buffer, class_243 camera) {
        if (mc.field_1761.method_2920() == class_1934.field_9219) {
            return;
        }
        ghosts.forEach((slot, entry) -> {
            GhostBlockRenderer ghost = entry.ghost;
            ghost.render(mc, ms, buffer, camera, entry.params);
        });
    }

    static class Entry {

        private GhostBlockRenderer ghost;
        private GhostBlockParams params;
        private int ticksToLive;

        public Entry(GhostBlockRenderer ghost, GhostBlockParams params) {
            this(ghost, params, 1);
        }

        public Entry(GhostBlockRenderer ghost, GhostBlockParams params, int ttl) {
            this.ghost = ghost;
            this.params = params;
            this.ticksToLive = ttl;
        }

        public boolean isAlive() {
            return ticksToLive >= 0;
        }
    }
}
