package com.zurrtum.create.client.catnip.render;

import com.zurrtum.create.client.ponder.enums.PonderSpecialTextures;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_10799;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_1921.class_4688;
import net.minecraft.class_2960;
import net.minecraft.class_4668;
import net.minecraft.class_4668.class_4683;

import static com.zurrtum.create.client.ponder.Ponder.MOD_ID;
import static net.minecraft.class_4668.*;

public class PonderRenderTypes {
    private static final Function<class_2960, class_1921> GUI_TEXTURED = class_156.method_34866(texture -> class_1921.method_24049(
        createLayerName("gui_textured"),
        786432,
        false,
        false,
        class_10799.field_56883,
        class_4688.method_23598().method_34577(new class_4668.class_4683(texture, false)).method_23617(false)
    ));
    private static final class_1921 GUI = class_1921.method_24049(
        createLayerName("gui"),
        786432,
        false,
        false,
        class_10799.field_56879,
        class_4688.method_23598().method_23617(false)
    );
    private static final class_1921.class_4687 GUI_INVERT = class_1921.method_24049(
        "gui_text_highlight",
        1536,
        false,
        false,
        class_10799.field_61068,
        class_4688.method_23598().method_23617(false)
    );
    private static final class_1921.class_4687 GUI_TEXT_HIGHLIGHT = class_1921.method_24049(
        "gui_text_highlight",
        1536,
        false,
        false,
        class_10799.field_56881,
        class_4688.method_23598().method_23617(false)
    );
    private static final class_1921 TRANSLUCENT = class_1921.method_24049(
        createLayerName("translucent"),
        786432,
        true,
        true,
        class_10799.field_56895,
        class_4688.method_23598().method_23608(field_21383).method_34577(field_21376).method_23610(field_25643).method_23617(true)
    );

    private static final class_1921 OUTLINE_SOLID = class_1921.method_24049(
        createLayerName("outline_solid"),
        256,
        false,
        false,
        class_10799.field_56901,
        class_4688.method_23598().method_34577(new class_4683(PonderSpecialTextures.BLANK.getLocation(), false)).method_23608(field_21383)
            .method_23611(field_21385).method_23617(false)
    );

    private static final BiFunction<class_2960, Boolean, class_1921> OUTLINE_TRANSLUCENT = class_156.method_34865((texture, cull) -> class_1921.method_24049(
        createLayerName("outline_translucent" + (cull ? "_cull" : "")),
        256,
        false,
        true,
        cull ? PonderRenderPipelines.RENDERTYPE_ITEM_ENTITY_TRANSLUCENT_CULL : PonderRenderPipelines.ENTITY_TRANSLUCENT,
        class_4688.method_23598().method_34577(new class_4683(texture, false)).method_23608(field_21383).method_23611(field_21385)
            .method_23610(field_25643).method_23617(false)
    ));

    private static final class_1921 FLUID = class_1921.method_24049(
        createLayerName("fluid"),
        256,
        false,
        true,
        class_10799.field_56895,
        class_4688.method_23598().method_34577(field_21376).method_23608(field_21383).method_23610(field_25643).method_23617(true)
    );

    public static class_1921 getGui() {
        return GUI;
    }

    public static class_1921 getGuiInvert() {
        return GUI_INVERT;
    }

    public static class_1921 getGuiTextHighlight() {
        return GUI_TEXT_HIGHLIGHT;
    }

    public static class_1921 getGuiTextured(class_2960 texture) {
        return GUI_TEXTURED.apply(texture);
    }

    public static class_1921 translucent() {
        return TRANSLUCENT;
    }

    public static class_1921 outlineSolid() {
        return OUTLINE_SOLID;
    }

    public static class_1921 outlineTranslucent(class_2960 texture, boolean cull) {
        return OUTLINE_TRANSLUCENT.apply(texture, cull);
    }

    //TODO vanilla uses the translucent render type for fluids, need to investigate if this is even needed
    public static class_1921 fluid() {
        return FLUID;
    }

    private static String createLayerName(String name) {
        return MOD_ID + ":" + name;
    }
}
