package com.zurrtum.create.client.catnip.render;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_2960;

public class StitchedSprite {
    private static final Map<class_2960, List<StitchedSprite>> ALL = new HashMap<>();

    protected final class_2960 atlasLocation;
    protected final class_2960 location;
    protected class_1058 sprite;

    public StitchedSprite(class_2960 atlas, class_2960 location) {
        atlasLocation = atlas;
        this.location = location;
        ALL.computeIfAbsent(atlasLocation, $ -> new ArrayList<>()).add(this);
    }

    @SuppressWarnings("deprecation")
    public StitchedSprite(class_2960 location) {
        this(class_1059.field_5275, location);
    }

    public static void onTextureStitchPost(class_1059 atlas) {
        class_2960 atlasLocation = atlas.method_24106();
        List<StitchedSprite> sprites = ALL.get(atlasLocation);
        if (sprites != null) {
            for (StitchedSprite sprite : sprites) {
                sprite.loadSprite(atlas);
            }
        }
    }

    protected void loadSprite(class_1059 atlas) {
        sprite = atlas.method_4608(location);
    }

    public class_2960 getAtlasLocation() {
        return atlasLocation;
    }

    public class_2960 getLocation() {
        return location;
    }

    public class_1058 get() {
        return sprite;
    }
}
