package com.zurrtum.create.client.catnip.render;

import com.zurrtum.create.client.catnip.client.render.model.BakedModelBufferer;
import com.zurrtum.create.client.catnip.client.render.model.ShadeSeparatedResultConsumer;
import com.zurrtum.create.client.flywheel.lib.model.baked.EmptyVirtualBlockGetter;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_10801;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_11515;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import net.minecraft.class_9801;

public class SuperBufferFactory {

    private static final class_5819 random = class_5819.method_43047();
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);
    private static SuperBufferFactory instance = new SuperBufferFactory();

    public static SuperBufferFactory getInstance() {
        return instance;
    }

    static void setInstance(SuperBufferFactory factory) {
        instance = factory;
    }

    public SuperByteBuffer create(class_9801 data) {
        return new ShadeSeparatingSuperByteBuffer(new MutableTemplateMesh(data).toImmutable());
    }

    public SuperByteBuffer createForBlock(class_2680 renderedState) {
        class_310 client = class_310.method_1551();
        class_1087 model = client.method_1541().method_3349(renderedState);
        return createForBlock(model.method_68512(client.field_1687 != null ? client.field_1687.field_9229 : random), renderedState, new class_4587());
    }

    public SuperByteBuffer createForBlock(class_10801 model, class_2680 referenceState) {
        return createForBlock(List.of(model), referenceState, new class_4587());
    }

    public SuperByteBuffer createForBlock(class_10801 model, class_2680 state, @Nullable class_4587 poseStack) {
        return createForBlock(List.of(model), state, poseStack);
    }

    public SuperByteBuffer createForBlock(List<class_10889> parts, class_2680 state, @Nullable class_4587 poseStack) {
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        SbbBuilder sbbBuilder = objects.sbbBuilder;
        sbbBuilder.prepare();
        BakedModelBufferer.bufferModel(parts, class_2338.field_10980, EmptyVirtualBlockGetter.FULL_DARK, state, poseStack, sbbBuilder);
        return sbbBuilder.build();
    }

    private static class SbbBuilder extends SuperByteBufferBuilder implements ShadeSeparatedResultConsumer {
        @Override
        public void accept(class_11515 renderType, boolean shaded, class_9801 data) {
            add(data, shaded);
        }
    }

    private static class ThreadLocalObjects {
        public final SbbBuilder sbbBuilder = new SbbBuilder();
    }
}
