package com.zurrtum.create.client.compat.rei.renderer;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllFluids;
import com.zurrtum.create.client.AllFluidConfigs;
import com.zurrtum.create.client.infrastructure.fluid.FluidConfig;
import com.zurrtum.create.content.fluids.potion.PotionFluidHandler;
import com.zurrtum.create.infrastructure.component.BottleType;
import dev.architectury.fluid.FluidStack;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.common.entry.EntryStack;
import net.minecraft.class_10799;
import net.minecraft.class_1844;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_9334;
import net.minecraft.class_9335;
import java.util.ArrayList;
import java.util.List;

public record FluidStackRenderer(EntryRenderer<FluidStack> origin) implements EntryRenderer<FluidStack> {
    @Override
    public void render(EntryStack<FluidStack> entry, class_332 graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
        FluidStack stack = entry.getValue();
        class_3611 fluid = stack.getFluid();
        FluidConfig config = AllFluidConfigs.get(fluid);
        if (config == null) {
            return;
        }
        int color = config.tint().apply(stack.method_57353().method_57940()) | 0xff000000;
        graphics.method_52710(class_10799.field_56883, config.still().get(), bounds.x, bounds.y, bounds.width, bounds.height, color);
    }

    @Override
    public Tooltip getTooltip(EntryStack<FluidStack> entry, TooltipContext context) {
        Tooltip tooltip = origin.getTooltip(entry, context);
        if (tooltip == null) {
            return null;
        }
        List<Tooltip.Entry> entries = tooltip.entries();
        Tooltip.Entry first = entries.getFirst();
        if (first.isText()) {
            FluidStack stack = entry.getValue();
            if (stack.getFluid() == AllFluids.POTION) {
                class_9335 components = stack.method_57353();
                class_1844 contents = components.method_58695(class_9334.field_49651, class_1844.field_49274);
                BottleType bottleType = components.method_58695(AllDataComponents.POTION_FLUID_BOTTLE_TYPE, BottleType.REGULAR);
                class_2561 name = contents.method_64195(PotionFluidHandler.itemFromBottleType(bottleType).method_7876() + ".effect.");
                List<Tooltip.Entry> list = new ArrayList<>();
                list.add(Tooltip.entry(name));
                contents.method_57409(context.vanillaContext(), text -> list.add(Tooltip.entry(text)), context.getFlag(), components);
                entries.removeFirst();
                entries.addAll(0, list);
            }
        }
        return tooltip;
    }
}
