package com.zurrtum.create.client.content.contraptions.actors.contraptionControls;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderState;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.contraptions.render.ClientContraption;
import com.zurrtum.create.client.foundation.utility.DyeHelper;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.actors.contraptionControls.ContraptionControlsBlock;
import com.zurrtum.create.content.contraptions.actors.contraptionControls.ContraptionControlsBlockEntity;
import com.zurrtum.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovement;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

import java.util.Random;
import net.minecraft.class_11659;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5481;
import net.minecraft.class_761;
import net.minecraft.class_765;

public class ContraptionControlsMovementRender implements MovementRenderBehaviour {
    private static final ThreadLocal<Random> RANDOM = ThreadLocal.withInitial(Random::new);

    @Override
    public MovementRenderState getRenderState(
        class_243 camera,
        class_327 textRenderer,
        MovementContext context,
        VirtualRenderWorld renderWorld,
        Matrix4f worldMatrix4f
    ) {
        if (!(context.temporaryData instanceof ContraptionControlsMovement.ElevatorFloorSelection efs)) {
            return null;
        }
        class_2680 blockState = context.state;
        if (!blockState.method_27852(AllBlocks.CONTRAPTION_CONTROLS)) {
            return null;
        }
        class_2338 pos = context.localPos;
        ContraptionControlsMovementRenderState state = new ContraptionControlsMovementRenderState(pos);
        float flicker = RANDOM.get().nextFloat();
        if (ClientContraption.getBlockEntityClientSide(context.contraption, pos) instanceof ContraptionControlsBlockEntity cbe) {
            state.buttondepth = -1 / 24f * cbe.button.getValue(AnimationTickHolder.getPartialTicks(renderWorld));
        }
        state.layer = class_1921.method_23577();
        class_2350 facing = blockState.method_11654(ContraptionControlsBlock.field_11177);
        state.button = CachedBuffers.partialFacing(AllPartialModels.CONTRAPTION_CONTROLS_BUTTON, blockState, facing.method_10153());
        state.light = class_761.method_23794(renderWorld, pos);
        state.world = context.world;
        state.worldMatrix4f = worldMatrix4f;
        String text = efs.currentShortName;
        String description = efs.currentLongName;
        class_243 position = context.position;
        float playerDistance = (float) (position == null ? 0 : camera.method_1025(position));
        boolean hideText = text.isBlank() || playerDistance > 100;
        boolean hideDescription = description.isBlank() || playerDistance > 20;
        if (hideText && hideDescription) {
            return state;
        }
        state.upAngle = AngleHelper.rad(AngleHelper.horizontalAngle(facing));
        state.westAngle = AngleHelper.rad(67.5f);
        Couple<Integer> couple = DyeHelper.getDyeColors(efs.targetYEqualsSelection ? class_1767.field_7952 : class_1767.field_7946);
        int brightColor = couple.getFirst();
        int darkColor = couple.getSecond();
        state.color = Color.mixColors(brightColor, darkColor, flicker / 4) | 0xFF000000;
        state.offsetZ = state.buttondepth - .25f;
        if (!hideText) {
            state.shadowColor = Color.mixColors(darkColor, 0, .35f) | 0xFF000000;
            int actualWidth = textRenderer.method_1727(text);
            int width = Math.max(actualWidth, 12);
            state.textScale = 1 / (5f * (width - .5f));
            state.textX = (float) Math.max(0, width - actualWidth) / 2;
            state.textY = (width - 8f) / 2;
            state.text = class_2561.method_43470(text).method_30937();
        }
        if (!hideDescription) {
            int actualWidth = textRenderer.method_1727(description);
            int width = Math.max(actualWidth, 55);
            state.descriptionScale = 1 / (3f * (width - .5f));
            state.descriptionX = (float) Math.max(0, width - actualWidth) / 2;
            state.descriptionY = (width - 8f) / 2;
            state.description = class_2561.method_43470(description).method_30937();
        }
        return state;
    }

    public static class ContraptionControlsMovementRenderState extends MovementRenderState implements class_11659.class_11660 {
        public class_1921 layer;
        public SuperByteBuffer button;
        public int light;
        public class_1937 world;
        public Matrix4f worldMatrix4f;
        public float buttondepth;
        public float upAngle;
        public float westAngle;
        public float offsetZ;
        public class_5481 text;
        public class_5481 description;
        public float textScale;
        public float textX;
        public float textY;
        public float descriptionScale;
        public float descriptionX;
        public float descriptionY;
        public int color;
        public int shadowColor;

        public ContraptionControlsMovementRenderState(class_2338 pos) {
            super(pos);
        }

        @Override
        public void render(class_4587 matrices, class_11659 queue) {
            matrices.method_22903();
            matrices.method_46416(0, buttondepth, 0);
            queue.method_73483(matrices, layer, this);
            matrices.method_22909();
            if (text != null || description != null) {
                matrices.method_22907(new Quaternionf().setAngleAxis(upAngle, 0, 1, 0));
                matrices.method_46416(0.4f, 1.125f, 0.5f);
                matrices.method_22907(new Quaternionf().setAngleAxis(westAngle, -1, 0, 0));
                if (text != null) {
                    matrices.method_22903();
                    matrices.method_46416(0, 0.15f, offsetZ);
                    matrices.method_22905(textScale, -textScale, textScale);
                    queue.method_73478(
                        matrices,
                        textX,
                        textY,
                        text,
                        false,
                        class_327.class_6415.field_33993,
                        class_765.field_32767,
                        color,
                        0,
                        0
                    );
                    matrices.method_46416(0.5f, 0.5f, -0.0625f);
                    queue.method_73478(
                        matrices,
                        textX,
                        textY,
                        text,
                        false,
                        class_327.class_6415.field_33993,
                        class_765.field_32767,
                        shadowColor,
                        0,
                        0
                    );
                    matrices.method_22909();
                }
                if (description != null) {
                    matrices.method_22903();
                    matrices.method_46416(-.0635f, 0.06f, offsetZ);
                    matrices.method_22905(descriptionScale, -descriptionScale, descriptionScale);
                    queue.method_73478(
                        matrices,
                        descriptionX,
                        descriptionY,
                        description,
                        false,
                        class_327.class_6415.field_33993,
                        class_765.field_32767,
                        color,
                        0,
                        0
                    );
                    matrices.method_22909();
                }
            }
        }

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            button.light(light).useLevelLight(world, worldMatrix4f).renderInto(matricesEntry, vertexConsumer);
        }
    }
}
