package com.zurrtum.create.client.content.contraptions.actors.contraptionControls;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.content.contraptions.actors.contraptionControls.ContraptionControlsBlock;
import com.zurrtum.create.content.contraptions.actors.contraptionControls.ContraptionControlsBlockEntity;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import org.jetbrains.annotations.Nullable;

public class ContraptionControlsRenderer extends SmartBlockEntityRenderer<ContraptionControlsBlockEntity, ContraptionControlsRenderer.ContraptionControlsRenderState> {
    public ContraptionControlsRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public ContraptionControlsRenderState createRenderState() {
        return new ContraptionControlsRenderState();
    }

    @Override
    public void updateRenderState(
        ContraptionControlsBlockEntity be,
        ContraptionControlsRenderState state,
        float tickProgress,
        class_243 cameraPos,
        class_11683.@Nullable class_11792 crumblingOverlay
    ) {
        super.updateRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        class_2350 facing = state.blockState.get(ContraptionControlsBlock.field_11177).getOpposite();
        class_243 buttonMovementAxis = VecHelper.rotate(new class_243(0, 1, -.325), AngleHelper.horizontalAngle(facing), class_2351.field_11052);
        state.buttonMovement = buttonMovementAxis.method_1021(-0.07f + -1 / 24f * be.button.getValue(tickProgress));
        state.buttonOffset = buttonMovementAxis.method_1021(0.07f);
        state.layer = class_1921.method_23577();
        state.button = CachedBuffers.partialFacing(AllPartialModels.CONTRAPTION_CONTROLS_BUTTON, state.blockState, facing);
        int i = (((int) be.indicator.getValue(tickProgress) / 45) % 8) + 8;
        state.indicator = CachedBuffers.partialFacing(AllPartialModels.CONTRAPTION_CONTROLS_INDICATOR.get(i % 8), state.blockState, facing);
    }

    @Override
    public void render(ContraptionControlsRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        matrices.method_22903();
        matrices.method_61958(state.buttonMovement);
        super.render(state, matrices, queue, cameraState);
        matrices.method_61958(state.buttonOffset);
        queue.method_73483(matrices, state.layer, state::renderButton);
        matrices.method_22909();
        queue.method_73483(matrices, state.layer, state::renderIndicator);
    }

    public static class ContraptionControlsRenderState extends SmartRenderState {
        public class_243 buttonMovement;
        public class_243 buttonOffset;
        public class_1921 layer;
        public SuperByteBuffer button;
        public SuperByteBuffer indicator;

        public void renderButton(class_4587.class_4665 entry, class_4588 vertexConsumer) {
            button.light(lightmapCoordinates).renderInto(entry, vertexConsumer);
        }

        public void renderIndicator(class_4587.class_4665 entry, class_4588 vertexConsumer) {
            indicator.light(lightmapCoordinates).renderInto(entry, vertexConsumer);
        }
    }
}
