package com.zurrtum.create.client.content.contraptions.actors.psi;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.content.contraptions.actors.psi.PortableStorageInterfaceBlock;
import com.zurrtum.create.content.contraptions.actors.psi.PortableStorageInterfaceBlockEntity;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

public class PortableStorageInterfaceRenderer implements class_827<PortableStorageInterfaceBlockEntity, PortableStorageInterfaceRenderer.PortableStorageInterfaceRenderState> {
    public PortableStorageInterfaceRenderer(class_5614.class_5615 context) {
    }

    @Override
    public PortableStorageInterfaceRenderState method_74335() {
        return new PortableStorageInterfaceRenderState();
    }

    @Override
    public void updateRenderState(
        PortableStorageInterfaceBlockEntity be,
        PortableStorageInterfaceRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        if (VisualizationManager.supportsVisualization(be.method_10997())) {
            return;
        }
        class_11954.method_74399(be, state, crumblingOverlay);
        state.layer = class_1921.method_23577();
        state.middle = CachedBuffers.partial(getMiddleForState(state.field_62674, be.isConnected()), state.field_62674);
        state.top = CachedBuffers.partial(getTopForState(state.field_62674), state.field_62674);
        class_2350 facing = state.field_62674.method_11654(PortableStorageInterfaceBlock.field_10927);
        state.yRot = class_3532.field_29847 * AngleHelper.horizontalAngle(facing);
        state.xRot = class_3532.field_29847 * (facing == class_2350.field_11036 ? 0 : facing == class_2350.field_11033 ? 180 : 90);
        state.topOffset = be.getExtensionDistance(tickProgress);
        state.middleOffset = state.topOffset * 0.5f + 0.375f;
    }

    @Override
    public void render(
        PortableStorageInterfaceRenderState state,
        class_4587 matrices,
        class_11659 queue,
        class_12075 cameraState
    ) {
        queue.method_73483(matrices, state.layer, state);
    }

    public static PartialModel getMiddleForState(class_2680 state, boolean lit) {
        if (state.method_27852(AllBlocks.PORTABLE_FLUID_INTERFACE))
            return lit ? AllPartialModels.PORTABLE_FLUID_INTERFACE_MIDDLE_POWERED : AllPartialModels.PORTABLE_FLUID_INTERFACE_MIDDLE;
        return lit ? AllPartialModels.PORTABLE_STORAGE_INTERFACE_MIDDLE_POWERED : AllPartialModels.PORTABLE_STORAGE_INTERFACE_MIDDLE;
    }

    public static PartialModel getTopForState(class_2680 state) {
        if (state.method_27852(AllBlocks.PORTABLE_FLUID_INTERFACE))
            return AllPartialModels.PORTABLE_FLUID_INTERFACE_TOP;
        return AllPartialModels.PORTABLE_STORAGE_INTERFACE_TOP;
    }

    public static class PortableStorageInterfaceRenderState extends class_11954 implements class_11659.class_11660 {
        public class_1921 layer;
        public SuperByteBuffer middle;
        public SuperByteBuffer top;
        public float yRot;
        public float xRot;
        public float middleOffset;
        public float topOffset;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            middle.center().rotateY(yRot).rotateX(xRot).uncenter().translate(0, middleOffset, 0).light(field_62676)
                .renderInto(matricesEntry, vertexConsumer);
            top.center().rotateY(yRot).rotateX(xRot).uncenter().translate(0, topOffset, 0).light(field_62676)
                .renderInto(matricesEntry, vertexConsumer);
        }
    }
}
