package com.zurrtum.create.client.content.contraptions.elevator;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.content.decoration.slidingDoor.SlidingDoorRenderer;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.Label;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.gui.widget.TooltipArea;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.decoration.slidingDoor.DoorControl;
import com.zurrtum.create.infrastructure.packet.c2s.ElevatorContactEditPacket;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import org.lwjgl.glfw.GLFW;

public class ElevatorContactScreen extends AbstractSimiScreen {

    private AllGuiTextures background;

    private class_342 shortNameInput;
    private class_342 longNameInput;
    private IconButton confirm;
    private ElementWidget renderedItem;

    private String shortName;
    private String longName;
    private DoorControl doorControl;

    private class_2338 pos;

    public ElevatorContactScreen(class_2338 pos, String prevShortName, String prevLongName, DoorControl prevDoorControl) {
        super(CreateLang.translateDirect("elevator_contact.title"));
        this.pos = pos;
        this.doorControl = prevDoorControl;
        background = AllGuiTextures.ELEVATOR_CONTACT;
        this.shortName = prevShortName;
        this.longName = prevLongName;
    }

    @Override
    public void method_25426() {
        setWindowSize(background.getWidth() + 30, background.getHeight());
        super.method_25426();

        int x = guiLeft;
        int y = guiTop;

        confirm = new IconButton(x + 200, y + 58, AllIcons.I_CONFIRM);
        confirm.withCallback(this::confirm);
        method_37063(confirm);

        shortNameInput = editBox(33, 30, 4);
        shortNameInput.method_1852(shortName);
        centerInput(x);
        shortNameInput.method_1863(s -> {
            shortName = s;
            centerInput(x);
        });
        shortNameInput.method_25365(true);
        method_25395(shortNameInput);
        shortNameInput.method_1884(0);

        longNameInput = editBox(63, 140, 30);
        longNameInput.method_1852(longName);
        longNameInput.method_1863(s -> longName = s);

        class_5250 rmbToEdit = CreateLang.translate("gui.schedule.lmb_edit").style(class_124.field_1063).style(class_124.field_1056).component();

        method_37060(new TooltipArea(x + 21, y + 23, 30, 18).withTooltip(ImmutableList.of(
            CreateLang.translate("elevator_contact.floor_identifier")
                .color(0x5391E1).component(), rmbToEdit
        )));

        method_37060(new TooltipArea(x + 57, y + 23, 147, 18).withTooltip(ImmutableList.of(
            CreateLang.translate("elevator_contact.floor_description").color(0x5391E1).component(),
            CreateLang.translate("crafting_blueprint.optional").style(class_124.field_1080).component(),
            rmbToEdit
        )));
        Pair<ScrollInput, Label> doorControlWidgets = SlidingDoorRenderer.createWidget(
            field_22787,
            x + 58,
            y + 57,
            mode -> doorControl = mode,
            doorControl
        );
        method_37063(doorControlWidgets.getFirst());
        method_37063(doorControlWidgets.getSecond());

        renderedItem = new ElementWidget(
            x + background.getWidth() + 6,
            y + background.getHeight() - 56
        ).showingElement(GuiGameElement.of(AllItems.ELEVATOR_CONTACT.method_7854()).scale(5));
        method_37063(renderedItem);
    }

    @Override
    public void method_25419() {
        super.method_25419();
        renderedItem.getRenderElement().clear();
    }

    private int centerInput(int x) {
        int centeredX = x + (shortName.isEmpty() ? 34 : 36 - field_22793.method_1727(shortName) / 2);
        shortNameInput.method_46421(centeredX);
        return centeredX;
    }

    private class_342 editBox(int x, int width, int chars) {
        class_342 editBox = new class_342(field_22793, guiLeft + x, guiTop + 30, width, 10, class_5244.field_39003);
        editBox.method_1868(-1);
        editBox.method_1860(-1);
        editBox.method_1858(false);
        editBox.method_1880(chars);
        editBox.method_25365(false);
        editBox.method_25402(new class_11909(0, 0, new class_11910(0, 0)), false);
        method_37063(editBox);
        return editBox;
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int x = guiLeft;
        int y = guiTop;

        background.render(graphics, x, y);

        class_5481 formattedcharsequence = field_22785.method_30937();
        graphics.method_51430(
            field_22793,
            formattedcharsequence,
            x + (background.getWidth() - 8) / 2 - field_22793.method_30880(formattedcharsequence) / 2,
            y + 6,
            0xFF2F3738,
            false
        );

        graphics.method_51427(AllItems.TRAIN_DOOR.method_7854(), x + 37, y + 58);
    }

    @Override
    public boolean method_25402(class_11909 click, boolean doubled) {
        boolean consumed = super.method_25402(click, doubled);

        if (!shortNameInput.method_25370()) {
            int length = shortNameInput.method_1882().length();
            shortNameInput.method_1884(length);
            shortNameInput.method_1875(length);
        }

        if (shortNameInput.method_25367())
            longNameInput.method_25402(new class_11909(0, 0, new class_11910(0, 0)), false);

        if (!consumed && click.comp_4798() > guiLeft + 22 && click.comp_4799() > guiTop + 24 && click.comp_4798() < guiLeft + 50 && click.comp_4799() < guiTop + 40) {
            method_25395(shortNameInput);
            shortNameInput.method_25365(true);
            return true;
        }

        return consumed;
    }

    @Override
    public boolean method_25404(class_11908 input) {
        if (super.method_25404(input))
            return true;
        int keyCode = input.comp_4795();
        if (keyCode == GLFW.GLFW_KEY_ENTER) {
            confirm();
            return true;
        }
        if (keyCode == 256 && this.method_25422()) {
            method_25419();
            return true;
        }
        return false;
    }

    private void confirm() {
        field_22787.field_1724.field_3944.method_52787(new ElevatorContactEditPacket(pos, shortName, longName, doorControl));
        method_25419();
    }

}
