package com.zurrtum.create.client.content.contraptions.elevator;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.client.content.contraptions.ContraptionHandlerClient;
import com.zurrtum.create.client.content.contraptions.actors.contraptionControls.ControlsSlot;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovement;
import com.zurrtum.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovement.ElevatorFloorSelection;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.contraptions.elevator.ElevatorContraption;
import org.apache.commons.lang3.tuple.MutablePair;

import java.lang.ref.WeakReference;
import java.util.Collection;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3499.class_3501;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class ElevatorControlsHandler {

    private static final ControlsSlot slot = new ElevatorControlsSlot();

    private static class ElevatorControlsSlot extends ControlsSlot {

        @Override
        public boolean testHit(class_1936 level, class_2338 pos, class_2680 state, class_243 localHit) {
            class_243 offset = getLocalOffset(state);
            if (offset == null)
                return false;
            return localHit.method_1022(offset) < scale * .85;
        }

    }

    public static boolean onScroll(class_310 mc, double delta) {
        class_638 world = mc.field_1687;
        if (world == null)
            return false;
        class_746 player = mc.field_1724;

        Couple<class_243> rayInputs = ContraptionHandlerClient.getRayInputs(mc, player);
        class_243 origin = rayInputs.getFirst();
        class_243 target = rayInputs.getSecond();
        class_238 aabb = new class_238(origin, target).method_1014(16);

        Collection<WeakReference<AbstractContraptionEntity>> contraptions = ContraptionHandlerClient.loadedContraptions.get(world).values();

        for (WeakReference<AbstractContraptionEntity> ref : contraptions) {
            AbstractContraptionEntity contraptionEntity = ref.get();
            if (contraptionEntity == null)
                continue;

            Contraption contraption = contraptionEntity.getContraption();
            if (!(contraption instanceof ElevatorContraption ec))
                continue;

            if (!contraptionEntity.method_5829().method_994(aabb))
                continue;

            class_3965 rayTraceResult = ContraptionHandlerClient.rayTraceContraption(origin, target, contraptionEntity);
            if (rayTraceResult == null)
                continue;

            class_2338 pos = rayTraceResult.method_17777();
            class_3501 info = contraption.getBlocks().get(pos);

            if (info == null)
                continue;
            if (!info.comp_1342().method_27852(AllBlocks.CONTRAPTION_CONTROLS))
                continue;

            if (!slot.testHit(world, pos, info.comp_1342(), rayTraceResult.method_17784().method_1020(class_243.method_24954(pos))))
                continue;

            MovementContext ctx = null;
            for (MutablePair<class_3501, MovementContext> pair : contraption.getActors()) {
                if (info.equals(pair.left)) {
                    ctx = pair.right;
                    break;
                }
            }
            if (ctx == null) {
                continue;
            }

            if (!(ctx.temporaryData instanceof ElevatorFloorSelection))
                ctx.temporaryData = new ElevatorFloorSelection();

            ElevatorFloorSelection efs = (ElevatorFloorSelection) ctx.temporaryData;
            int prev = efs.currentIndex;
            // Round away from 0. delta may be ~0.9, which is implicitly floor'd during a pure cast.
            efs.currentIndex += (int) (delta > 0 ? Math.ceil(delta) : Math.floor(delta));
            ContraptionControlsMovement.tickFloorSelection(efs, ec);

            if (prev != efs.currentIndex && !ec.namesList.isEmpty()) {
                float pitch = (efs.currentIndex) / (float) (ec.namesList.size());
                pitch = class_3532.method_16439(pitch, 1f, 1.5f);
                AllSoundEvents.SCROLL_VALUE.play(
                    world,
                    player,
                    class_2338.method_49638(contraptionEntity.toGlobalVector(rayTraceResult.method_17784(), 1)),
                    1,
                    pitch
                );
            }

            return true;
        }

        return false;
    }

}
