package com.zurrtum.create.client.content.equipment.blueprint;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.AllPackets;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.menu.AbstractSimiContainerScreen;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.equipment.blueprint.BlueprintEntity;
import com.zurrtum.create.content.equipment.blueprint.BlueprintEntity.BlueprintSection;
import com.zurrtum.create.content.equipment.blueprint.BlueprintMenu;
import com.zurrtum.create.foundation.gui.menu.MenuType;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_768;
import net.minecraft.class_7833;
import net.minecraft.class_9129;

import static com.zurrtum.create.client.foundation.gui.AllGuiTextures.PLAYER_INVENTORY;

public class BlueprintScreen extends AbstractSimiContainerScreen<BlueprintMenu> {

    protected AllGuiTextures background;
    private List<class_768> extraAreas = Collections.emptyList();

    private IconButton resetButton;
    private IconButton confirmButton;
    private ElementWidget renderedItem;

    public BlueprintScreen(BlueprintMenu menu, class_1661 inv, class_2561 title) {
        super(menu, inv, title);
        this.background = AllGuiTextures.BLUEPRINT;
    }

    public static BlueprintScreen create(
        class_310 mc,
        MenuType<BlueprintSection> type,
        int syncId,
        class_1661 inventory,
        class_2561 title,
        class_9129 extraData
    ) {
        int entityID = extraData.method_10816();
        int section = extraData.method_10816();
        class_1297 entityByID = mc.field_1687.method_8469(entityID);
        if (!(entityByID instanceof BlueprintEntity blueprintEntity))
            return null;
        return type.create(BlueprintScreen::new, syncId, inventory, title, blueprintEntity.getSection(section));
    }

    @Override
    protected void method_25426() {
        setWindowSize(background.getWidth(), background.getHeight() + 4 + PLAYER_INVENTORY.getHeight());
        setWindowOffset(1, 0);
        super.method_25426();

        resetButton = new IconButton(field_2776 + background.getWidth() - 62, field_2800 + background.getHeight() - 24, AllIcons.I_TRASH);
        resetButton.withCallback(() -> {
            field_2797.clearContents();
            contentsCleared();
            field_22787.field_1724.field_3944.method_52787(AllPackets.CLEAR_CONTAINER);
        });
        confirmButton = new IconButton(field_2776 + background.getWidth() - 33, field_2800 + background.getHeight() - 24, AllIcons.I_CONFIRM);
        confirmButton.withCallback(() -> {
            field_22787.field_1724.method_7346();
        });

        method_37063(resetButton);
        method_37063(confirmButton);

        extraAreas = ImmutableList.of(new class_768(field_2776 + background.getWidth(), field_2800 + background.getHeight() - 36, 56, 44));

        renderedItem = new ElementWidget(field_2776 + background.getWidth() + 1, field_2800 + background.getHeight() - 34).showingElement(GuiGameElement.of(
            AllPartialModels.CRAFTING_BLUEPRINT_1x1).scale(2.5F).transform(this::transform).padding(13));
        method_37063(renderedItem);
    }

    private void transform(class_4587 ms, float p) {
        ms.method_46416(0.48F, 0.04F, 0);
        ms.method_22905(1, -1, 1);
        ms.method_22907(class_7833.field_40718.rotationDegrees(22.5F));
        ms.method_22907(class_7833.field_40714.rotationDegrees(45F));
        ms.method_22907(class_7833.field_40716.rotationDegrees(-45F));
    }

    @Override
    public void method_25419() {
        super.method_25419();
        renderedItem.getRenderElement().clear();
    }

    @Override
    protected void method_2389(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        int invX = getLeftOfCentered(PLAYER_INVENTORY.getWidth());
        int invY = field_2800 + background.getHeight() + 4;
        renderPlayerInventory(graphics, invX, invY);

        background.render(graphics, field_2776, field_2800);
        graphics.method_51439(field_22793, field_22785, field_2776 + 15, field_2800 + 4, 0xFFFFFFFF, false);

        //TODO
        //        GuiGameElement.of(AllPartialModels.CRAFTING_BLUEPRINT_1x1)
        //            .<GuiGameElement.GuiRenderBuilder>at(x + background.getWidth() + 20, y + background.getHeight() - 32, 0).rotate(45, -45, 22.5f).scale(40)
        //            .render(graphics);
    }

    @Override
    protected void method_2380(class_332 graphics, int x, int y) {
        if (!field_2797.method_34255().method_7960() || field_2787 == null || field_2787.field_7871 == field_2797.playerInventory) {
            super.method_2380(graphics, x, y);
            return;
        }

        List<class_2561> list = new LinkedList<>();
        if (field_2787.method_7681())
            list = method_51454(field_2787.method_7677());

        graphics.method_51434(field_22793, addToTooltip(list, field_2787.method_34266()), x, y);
    }

    private List<class_2561> addToTooltip(List<class_2561> list, int slot) {
        if (slot < 0 || slot > 10)
            return list;

        if (slot < 9) {
            list.add(CreateLang.translateDirect("crafting_blueprint.crafting_slot").method_27692(class_124.field_1065));
            list.add(CreateLang.translateDirect("crafting_blueprint.filter_items_viable").method_27692(class_124.field_1080));
        } else if (slot == 9) {
            list.add(CreateLang.translateDirect("crafting_blueprint.display_slot").method_27692(class_124.field_1065));
        } else {
            list.add(CreateLang.translateDirect("crafting_blueprint.secondary_display_slot").method_27692(class_124.field_1065));
            list.add(CreateLang.translateDirect("crafting_blueprint.optional").method_27692(class_124.field_1080));
        }

        return list;
    }

    @Override
    protected void method_37432() {
        if (!field_2797.contentHolder.isEntityAlive())
            field_22787.field_1724.method_7346();

        super.method_37432();
    }

    protected void contentsCleared() {
    }

    @Override
    public List<class_768> getExtraAreas() {
        return extraAreas;
    }

}
