package com.zurrtum.create.client.content.equipment.clipboard;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.content.trains.track.TrackBlockOutline;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.equipment.clipboard.ClipboardBlockEntity;
import com.zurrtum.create.content.equipment.clipboard.ClipboardCloneable;
import com.zurrtum.create.content.redstone.link.ServerLinkBehaviour;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollValueBehaviour;
import com.zurrtum.create.infrastructure.component.ClipboardContent;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_8942;

import static com.zurrtum.create.Create.LOGGER;

public class ClipboardValueSettingsClientHandler {
    public static boolean drawCustomBlockSelection(
        class_310 mc,
        class_2338 pos,
        class_4597 vertexConsumerProvider,
        class_243 camPos,
        class_4587 ms
    ) {
        class_746 player = mc.field_1724;
        if (player == null || player.method_7325())
            return false;
        if (!player.method_6047().method_31574(AllItems.CLIPBOARD))
            return false;
        class_638 world = mc.field_1687;
        if (!world.method_8621().method_11952(pos))
            return false;
        class_2680 blockstate = world.method_8320(pos);

        if (!(world.method_8321(pos) instanceof SmartBlockEntity smartBE))
            return false;
        if (!(smartBE instanceof ClipboardBlockEntity) && !(smartBE instanceof ClipboardCloneable)) {
            if (mc.field_1765 instanceof class_3965 target) {
                class_5455 registryManager = world.method_30349();
                class_2350 side = target.method_17780();
                if (Stream.of(ServerScrollValueBehaviour.TYPE, ServerFilteringBehaviour.TYPE, ServerLinkBehaviour.TYPE)
                    .noneMatch(type -> smartBE.getBehaviour(type) instanceof ClipboardCloneable cc && cc.canWrite(registryManager, side))) {
                    return false;
                }
            }
        }

        class_265 shape = blockstate.method_26218(world, pos);
        if (shape.method_1110())
            return false;

        class_4588 vb = vertexConsumerProvider.method_73477(class_1921.method_23594());

        ms.method_22903();
        ms.method_22904(pos.method_10263() - camPos.field_1352, pos.method_10264() - camPos.field_1351, pos.method_10260() - camPos.field_1350);
        TrackBlockOutline.renderShape(shape, ms, vb, true);
        ms.method_22909();
        return true;
    }

    public static void clientTick(class_310 mc) {
        if (!(mc.field_1765 instanceof class_3965 target))
            return;
        class_746 player = mc.field_1724;
        class_1799 stack = player.method_6047();
        if (!stack.method_31574(AllItems.CLIPBOARD))
            return;
        class_2338 pos = target.method_17777();
        class_638 world = mc.field_1687;
        if (!(world.method_8321(pos) instanceof SmartBlockEntity smartBE))
            return;

        if (smartBE instanceof ClipboardBlockEntity) {
            List<class_5250> tip = new ArrayList<>();
            tip.add(CreateLang.translateDirect("clipboard.actions"));
            tip.add(CreateLang.translateDirect("clipboard.copy_other_clipboard", class_2561.method_43472("key.use")));
            Create.VALUE_SETTINGS_HANDLER.showHoverTip(mc, tip);
            return;
        }


        class_2350 side = target.method_17780();
        boolean canCopy = Stream.of(ServerScrollValueBehaviour.TYPE, ServerFilteringBehaviour.TYPE, ServerLinkBehaviour.TYPE)
            .anyMatch(type -> smartBE.getBehaviour(type) instanceof ClipboardCloneable cc && cc.canWrite(
                world.method_30349(),
                side
            )) || smartBE instanceof ClipboardCloneable ccbe && ccbe.canWrite(world.method_30349(), side);

        boolean canPaste;
        ClipboardContent content = stack.method_58694(AllDataComponents.CLIPBOARD_CONTENT);
        if (content == null) {
            return;
        }
        class_2487 tagElement = content.copiedValues().orElse(null);
        if (tagElement == null) {
            canPaste = false;
        } else {
            try (class_8942.class_11340 logging = new class_8942.class_11340(smartBE.method_71402(), LOGGER)) {
                class_11368 view = class_11352.method_71417(logging, world.method_30349(), tagElement);
                canPaste = (Stream.of(ServerScrollValueBehaviour.TYPE, ServerFilteringBehaviour.TYPE, ServerLinkBehaviour.TYPE)
                    .anyMatch(type -> smartBE.getBehaviour(type) instanceof ClipboardCloneable cc && view.method_71420(cc.getClipboardKey())
                        .map(v -> cc.readFromClipboard(v, player, side, true))
                        .orElse(false)) || smartBE instanceof ClipboardCloneable ccbe && view.method_71420(ccbe.getClipboardKey())
                    .map(v -> ccbe.readFromClipboard(v, player, side, true)).orElse(false));
            }
        }

        if (!canCopy && !canPaste)
            return;

        List<class_5250> tip = new ArrayList<>();
        tip.add(CreateLang.translateDirect("clipboard.actions"));
        if (canCopy)
            tip.add(CreateLang.translateDirect("clipboard.to_copy", class_2561.method_43472("key.use")));
        if (canPaste)
            tip.add(CreateLang.translateDirect("clipboard.to_paste", class_2561.method_43472("key.attack")));

        Create.VALUE_SETTINGS_HANDLER.showHoverTip(mc, tip);
    }
}
